/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.TreeMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jsampler.CC;
import org.jsampler.MidiInstrument;
import org.jsampler.event.MidiInstrumentMapEvent;
import org.jsampler.event.MidiInstrumentMapListener;
import org.linuxsampler.lscp.MidiInstrumentEntry;
import org.linuxsampler.lscp.MidiInstrumentMapInfo;

public class MidiInstrumentMap {
    MidiInstrumentMapInfo info;
    private final TreeMap<MidiInstrumentEntry, MidiInstrument> instrMap = new TreeMap();
    private final Vector<MidiInstrumentMapListener> listeners = new Vector();

    public MidiInstrumentMap(MidiInstrumentMapInfo midiInstrumentMapInfo) {
        this.info = midiInstrumentMapInfo;
    }

    public void addMidiInstrumentMapListener(MidiInstrumentMapListener midiInstrumentMapListener) {
        this.listeners.add(midiInstrumentMapListener);
    }

    public void removeMidiInstrumentMapListener(MidiInstrumentMapListener midiInstrumentMapListener) {
        this.listeners.remove(midiInstrumentMapListener);
    }

    public int getMapId() {
        return this.info.getMapId();
    }

    public String getName() {
        return this.info.getName();
    }

    public void setName(String string) {
        if (this.info.getName().equals(string)) {
            return;
        }
        this.info.setName(string);
        this.fireNameChanged();
    }

    public MidiInstrumentMapInfo getInfo() {
        return this.info;
    }

    public void setInfo(MidiInstrumentMapInfo midiInstrumentMapInfo) {
        this.info = midiInstrumentMapInfo;
        this.fireNameChanged();
    }

    public Integer[] getMidiBanks() {
        Vector<Integer> vector = new Vector<Integer>();
        for (MidiInstrumentEntry midiInstrumentEntry : this.instrMap.keySet()) {
            if (vector.isEmpty()) {
                vector.add(midiInstrumentEntry.getMidiBank());
                continue;
            }
            if (midiInstrumentEntry.getMidiBank() < (Integer)vector.lastElement()) {
                throw new RuntimeException("Unsorted map!");
            }
            if (midiInstrumentEntry.getMidiBank() <= (Integer)vector.lastElement()) continue;
            vector.add(midiInstrumentEntry.getMidiBank());
        }
        return vector.toArray(new Integer[vector.size()]);
    }

    public MidiInstrument getMidiInstrument(int n, int n2) {
        return this.instrMap.get(new MidiInstrumentEntry(n, n2));
    }

    public MidiInstrument[] getMidiInstruments(int n) {
        Vector<MidiInstrument> vector = new Vector<MidiInstrument>();
        for (MidiInstrumentEntry midiInstrumentEntry : this.instrMap.keySet()) {
            if (midiInstrumentEntry.getMidiBank() != n) continue;
            vector.add(this.instrMap.get(midiInstrumentEntry));
        }
        return vector.toArray(new MidiInstrument[vector.size()]);
    }

    public MidiInstrument[] getAllMidiInstruments() {
        Vector<MidiInstrument> vector = new Vector<MidiInstrument>();
        for (MidiInstrument midiInstrument : this.instrMap.values()) {
            vector.add(midiInstrument);
        }
        return vector.toArray(new MidiInstrument[vector.size()]);
    }

    public void mapMidiInstrument(MidiInstrumentEntry midiInstrumentEntry, MidiInstrument midiInstrument) {
        MidiInstrument midiInstrument2 = this.instrMap.remove(midiInstrumentEntry);
        if (midiInstrument2 != null) {
            this.fireInstrumentRemoved(midiInstrumentEntry, midiInstrument2);
        }
        this.instrMap.put(midiInstrumentEntry, midiInstrument);
        this.fireInstrumentAdded(midiInstrumentEntry, midiInstrument);
    }

    public MidiInstrument unmapMidiInstrument(MidiInstrumentEntry midiInstrumentEntry) {
        MidiInstrument midiInstrument = this.instrMap.remove(midiInstrumentEntry);
        if (midiInstrument != null) {
            this.fireInstrumentRemoved(midiInstrumentEntry, midiInstrument);
        }
        return midiInstrument;
    }

    public MidiInstrumentEntry getAvailableEntry() {
        int n;
        int n2;
        int n3 = CC.getViewConfig().preferences().getIntProperty("lastUsedMidiBank", 0);
        MidiInstrumentEntry midiInstrumentEntry = this.getAvailableEntry(n3, (n2 = CC.getViewConfig().preferences().getIntProperty("lastUsedMidiProgram", 0)) + 1);
        if (midiInstrumentEntry != null) {
            return midiInstrumentEntry;
        }
        for (n = n3; n <= 16129; ++n) {
            midiInstrumentEntry = this.getAvailableEntry(n);
            if (midiInstrumentEntry == null) continue;
            return midiInstrumentEntry;
        }
        for (n = 0; n < n3; ++n) {
            midiInstrumentEntry = this.getAvailableEntry(n);
            if (midiInstrumentEntry == null) continue;
            return midiInstrumentEntry;
        }
        return null;
    }

    public MidiInstrumentEntry getAvailableEntry(int n) {
        return this.getAvailableEntry(n, 0);
    }

    public MidiInstrumentEntry getAvailableEntry(int n, int n2) {
        int n3;
        if (n2 > 127) {
            return null;
        }
        Vector<MidiInstrument> vector = new Vector<MidiInstrument>();
        for (MidiInstrument midiInstrument : this.instrMap.values()) {
            n3 = midiInstrument.getInfo().getMidiProgram();
            int n4 = midiInstrument.getInfo().getMidiBank();
            if (n4 == n && n3 >= n2) {
                vector.add(midiInstrument);
            }
            if (n4 <= n) continue;
            break;
        }
        if (vector.isEmpty()) {
            if (n2 < 128) {
                return new MidiInstrumentEntry(n, n2);
            }
            return new MidiInstrumentEntry(n, 127);
        }
        int n5 = ((MidiInstrument)vector.get(0)).getInfo().getMidiProgram();
        if (n2 < n5) {
            return new MidiInstrumentEntry(n, n2);
        }
        for (int i = 1; i < vector.size(); ++i) {
            n3 = ((MidiInstrument)vector.get(i)).getInfo().getMidiProgram();
            if (n3 - n5 > 1) {
                return new MidiInstrumentEntry(n, n5 + 1);
            }
            n5 = n3;
        }
        if (n5 < 127) {
            return new MidiInstrumentEntry(n, n5 + 1);
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    private void fireNameChanged() {
        final MidiInstrumentMapEvent midiInstrumentMapEvent = new MidiInstrumentMapEvent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MidiInstrumentMap.this.fireNameChanged(midiInstrumentMapEvent);
            }
        });
    }

    private void fireNameChanged(MidiInstrumentMapEvent midiInstrumentMapEvent) {
        for (MidiInstrumentMapListener midiInstrumentMapListener : this.listeners) {
            midiInstrumentMapListener.nameChanged(midiInstrumentMapEvent);
        }
    }

    private void fireInstrumentAdded(MidiInstrumentEntry midiInstrumentEntry, MidiInstrument midiInstrument) {
        final MidiInstrumentMapEvent midiInstrumentMapEvent = new MidiInstrumentMapEvent(this, midiInstrumentEntry, midiInstrument);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MidiInstrumentMap.this.fireInstrumentAdded(midiInstrumentMapEvent);
            }
        });
    }

    private void fireInstrumentAdded(MidiInstrumentMapEvent midiInstrumentMapEvent) {
        for (MidiInstrumentMapListener midiInstrumentMapListener : this.listeners) {
            midiInstrumentMapListener.instrumentAdded(midiInstrumentMapEvent);
        }
    }

    private void fireInstrumentRemoved(MidiInstrumentEntry midiInstrumentEntry, MidiInstrument midiInstrument) {
        final MidiInstrumentMapEvent midiInstrumentMapEvent = new MidiInstrumentMapEvent(this, midiInstrumentEntry, midiInstrument);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MidiInstrumentMap.this.fireInstrumentRemoved(midiInstrumentMapEvent);
            }
        });
    }

    private void fireInstrumentRemoved(MidiInstrumentMapEvent midiInstrumentMapEvent) {
        for (MidiInstrumentMapListener midiInstrumentMapListener : this.listeners) {
            midiInstrumentMapListener.instrumentRemoved(midiInstrumentMapEvent);
        }
    }
}

