/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.keycloak.metrics;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.prometheus.client.exporter.PushGateway;
import io.prometheus.client.exporter.common.TextFormat;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.OperationType;

public final class PrometheusExporter {
    private static final String USER_EVENT_PREFIX = "keycloak_user_event_";
    private static final String ADMIN_EVENT_PREFIX = "keycloak_admin_event_";
    private static final String PROVIDER_KEYCLOAK_OPENID = "keycloak";
    private static PrometheusExporter INSTANCE;
    private static final Logger logger;
    final Map<String, Counter> counters = new HashMap<String, Counter>();
    final Counter totalLogins;
    final Counter totalFailedLoginAttempts;
    final Counter totalRegistrations;
    final Counter totalRegistrationsErrors;
    final Counter responseErrors;
    final Histogram requestDuration;
    final PushGateway PUSH_GATEWAY = this.buildPushGateWay();

    private PrometheusExporter() {
        String counterName;
        this.totalLogins = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_logins")).help("Total successful logins")).labelNames("realm", "provider", "client_id")).register();
        this.totalFailedLoginAttempts = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_failed_login_attempts")).help("Total failed login attempts")).labelNames("realm", "provider", "error", "client_id")).register();
        this.totalRegistrations = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_registrations")).help("Total registered users")).labelNames("realm", "provider", "client_id")).register();
        this.totalRegistrationsErrors = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_registrations_errors")).help("Total errors on registrations")).labelNames("realm", "provider", "error", "client_id")).register();
        this.responseErrors = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("keycloak_response_errors")).help("Total number of error responses")).labelNames("code", "method")).register();
        this.requestDuration = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("keycloak_request_duration")).help("Request duration")).buckets(50.0, 100.0, 250.0, 500.0, 1000.0, 2000.0, 10000.0, 30000.0).labelNames("method")).register();
        for (EventType eventType : EventType.values()) {
            if (eventType.equals((Object)EventType.LOGIN) || eventType.equals((Object)EventType.LOGIN_ERROR) || eventType.equals((Object)EventType.REGISTER)) continue;
            counterName = this.buildCounterName(eventType);
            this.counters.put(counterName, PrometheusExporter.createCounter(counterName, false));
        }
        for (EventType eventType : OperationType.values()) {
            counterName = this.buildCounterName((OperationType)eventType);
            this.counters.put(counterName, PrometheusExporter.createCounter(counterName, true));
        }
        DefaultExports.initialize();
    }

    public static synchronized PrometheusExporter instance() {
        if (INSTANCE == null) {
            INSTANCE = new PrometheusExporter();
        }
        return INSTANCE;
    }

    private static Counter createCounter(String name, boolean isAdmin) {
        Counter.Builder counter = (Counter.Builder)Counter.build().name(name);
        if (isAdmin) {
            ((Counter.Builder)counter.labelNames("realm", "resource")).help("Generic KeyCloak Admin event");
        } else {
            ((Counter.Builder)counter.labelNames("realm")).help("Generic KeyCloak User event");
        }
        return (Counter)counter.register();
    }

    public void recordGenericEvent(Event event) {
        String counterName = this.buildCounterName(event.getType());
        if (this.counters.get(counterName) == null) {
            logger.warnf("Counter for event type %s does not exist. Realm: %s", (Object)event.getType().name(), (Object)this.nullToEmpty(event.getRealmId()));
            return;
        }
        ((Counter.Child)this.counters.get(counterName).labels(this.nullToEmpty(event.getRealmId()))).inc();
        this.pushAsync();
    }

    public void recordGenericAdminEvent(AdminEvent event) {
        String counterName = this.buildCounterName(event.getOperationType());
        if (this.counters.get(counterName) == null) {
            logger.warnf("Counter for admin event operation type %s does not exist. Resource type: %s, realm: %s", (Object)event.getOperationType().name(), (Object)event.getResourceType().name(), (Object)event.getRealmId());
            return;
        }
        ((Counter.Child)this.counters.get(counterName).labels(this.nullToEmpty(event.getRealmId()), event.getResourceType().name())).inc();
        this.pushAsync();
    }

    public void recordLogin(Event event) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalLogins.labels(this.nullToEmpty(event.getRealmId()), provider, this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordRegistration(Event event) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalRegistrations.labels(this.nullToEmpty(event.getRealmId()), provider, this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordRegistrationError(Event event) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalRegistrationsErrors.labels(this.nullToEmpty(event.getRealmId()), provider, this.nullToEmpty(event.getError()), this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordLoginError(Event event) {
        String provider = this.getIdentityProvider(event);
        ((Counter.Child)this.totalFailedLoginAttempts.labels(this.nullToEmpty(event.getRealmId()), provider, this.nullToEmpty(event.getError()), this.nullToEmpty(event.getClientId()))).inc();
        this.pushAsync();
    }

    public void recordRequestDuration(double amt, String method) {
        ((Histogram.Child)this.requestDuration.labels(method)).observe(amt);
        this.pushAsync();
    }

    public void recordResponseError(int code, String method) {
        ((Counter.Child)this.responseErrors.labels(Integer.toString(code), method)).inc();
        this.pushAsync();
    }

    private String getIdentityProvider(Event event) {
        String identityProvider = null;
        if (event.getDetails() != null) {
            identityProvider = (String)event.getDetails().get("identity_provider");
        }
        if (identityProvider == null) {
            identityProvider = PROVIDER_KEYCLOAK_OPENID;
        }
        return identityProvider;
    }

    public void export(OutputStream stream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        TextFormat.write004(writer, CollectorRegistry.defaultRegistry.metricFamilySamples());
        ((Writer)writer).flush();
    }

    private PushGateway buildPushGateWay() {
        String host = System.getenv("PROMETHEUS_PUSHGATEWAY_ADDRESS");
        if (host != null) {
            return new PushGateway(host);
        }
        return null;
    }

    public void pushAsync() {
        CompletableFuture.runAsync(() -> this.push());
    }

    private void push() {
        if (this.PUSH_GATEWAY != null) {
            try {
                String instanceIp = InetAddress.getLocalHost().getHostAddress();
                Map<String, String> groupingKey = Collections.singletonMap("instance", instanceIp);
                this.PUSH_GATEWAY.pushAdd(CollectorRegistry.defaultRegistry, PROVIDER_KEYCLOAK_OPENID, groupingKey);
            }
            catch (IOException e) {
                logger.error((Object)"Unable to send to prometheus PushGateway", (Throwable)e);
            }
        }
    }

    private String buildCounterName(OperationType type) {
        return ADMIN_EVENT_PREFIX + type.name();
    }

    private String buildCounterName(EventType type) {
        return USER_EVENT_PREFIX + type.name();
    }

    private String nullToEmpty(String value) {
        return value == null ? "" : value;
    }

    static {
        logger = Logger.getLogger(PrometheusExporter.class);
    }
}

