/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.awt.XContainerWindowEventHandler;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XDialogProvider2;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.openoffice.da.comp.w2lcommon.helper.DialogAccess;
import org.openoffice.da.comp.w2lcommon.helper.FilePicker;
import org.openoffice.da.comp.w2lcommon.helper.StreamGobbler;
import org.openoffice.da.comp.writer2latex.ExternalApps;
import org.openoffice.da.comp.writer2latex.Messages;

public final class ApplicationsDialog
extends WeakBase
implements XServiceInfo,
XContainerWindowEventHandler {
    private XComponentContext xContext;
    private FilePicker filePicker;
    private ExternalApps externalApps;
    public static String __serviceName = "org.openoffice.da.writer2latex.ApplicationsDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer2latex.ApplicationsDialog";

    public ApplicationsDialog(XComponentContext xContext) {
        this.xContext = xContext;
        this.externalApps = new ExternalApps(xContext);
        this.filePicker = new FilePicker(xContext);
    }

    public boolean callHandlerMethod(XWindow xWindow, Object event, String sMethod) throws WrappedTargetException {
        XDialog xDialog = (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)xWindow);
        DialogAccess dlg = new DialogAccess(xDialog);
        try {
            if (sMethod.equals("external_event")) {
                return this.handleExternalEvent(dlg, event);
            }
            if (sMethod.equals("AfterExportChange")) {
                return this.changeProcessingLevel(dlg);
            }
            if (sMethod.equals("ApplicationChange")) {
                return this.changeApplication(dlg);
            }
            if (sMethod.equals("UseDefaultChange")) {
                return this.useDefaultChange(dlg) && this.updateApplication(dlg);
            }
            if (sMethod.equals("BrowseClick")) {
                return this.browseForExecutable(dlg);
            }
            if (sMethod.equals("ExecutableUnfocus")) {
                return this.updateApplication(dlg);
            }
            if (sMethod.equals("OptionsUnfocus")) {
                return this.updateApplication(dlg);
            }
            if (sMethod.equals("AutomaticClick")) {
                return this.autoConfigure(dlg);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (com.sun.star.uno.Exception e) {
            throw new WrappedTargetException(sMethod, (Object)this, (Object)e);
        }
        return false;
    }

    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"external_event", "AfterExportChange", "ApplicationChange", "BrowseClick", "ExecutableUnfocus", "OptionsUnfocus", "AutomaticClick"};
        return sNames;
    }

    public boolean supportsService(String sServiceName) {
        return sServiceName.equals(__serviceName);
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public String[] getSupportedServiceNames() {
        String[] sSupportedServiceNames = new String[]{__serviceName};
        return sSupportedServiceNames;
    }

    private boolean handleExternalEvent(DialogAccess dlg, Object aEventObject) throws com.sun.star.uno.Exception {
        try {
            String sMethod = AnyConverter.toString((Object)aEventObject);
            if (sMethod.equals("ok")) {
                this.externalApps.save();
                return true;
            }
            if (sMethod.equals("back") || sMethod.equals("initialize")) {
                this.externalApps.load();
                this.updateProcessingLevel(dlg);
                return this.changeApplication(dlg);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Method external_event requires a string in the event object argument.", (Object)this, -1);
        }
        return false;
    }

    private boolean changeProcessingLevel(DialogAccess dlg) {
        this.externalApps.setProcessingLevel(dlg.getListBoxSelectedItem("AfterExport"));
        return true;
    }

    private boolean updateProcessingLevel(DialogAccess dlg) {
        dlg.setListBoxSelectedItem("AfterExport", this.externalApps.getProcessingLevel());
        return true;
    }

    private boolean changeApplication(DialogAccess dlg) {
        String sAppName = this.getSelectedAppName(dlg);
        if (sAppName != null) {
            String[] s = this.externalApps.getApplication(sAppName);
            dlg.setComboBoxText("Executable", s[0]);
            dlg.setComboBoxText("Options", s[1]);
            dlg.setCheckBoxStateAsBoolean("UseDefault", this.externalApps.getUseDefaultApplication(sAppName));
            dlg.setControlEnabled("UseDefault", this.externalApps.isViewer(sAppName));
            this.useDefaultChange(dlg);
        }
        return true;
    }

    private boolean useDefaultChange(DialogAccess dlg) {
        boolean bCustomApp = !dlg.getCheckBoxStateAsBoolean("UseDefault");
        dlg.setControlEnabled("ExecutableLabel", bCustomApp);
        dlg.setControlEnabled("Executable", bCustomApp);
        dlg.setControlEnabled("OptionsLabel", bCustomApp);
        dlg.setControlEnabled("Options", bCustomApp);
        dlg.setControlEnabled("BrowseButton", bCustomApp);
        return true;
    }

    private boolean browseForExecutable(DialogAccess dlg) {
        String sPath = this.filePicker.getPath();
        if (sPath != null) {
            try {
                dlg.setComboBoxText("Executable", new File(new URI(sPath)).getCanonicalPath());
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.updateApplication(dlg);
        }
        return true;
    }

    private boolean updateApplication(DialogAccess dlg) {
        String sAppName = this.getSelectedAppName(dlg);
        if (sAppName != null) {
            this.externalApps.setApplication(sAppName, dlg.getComboBoxText("Executable"), dlg.getComboBoxText("Options"));
            this.externalApps.setUseDefaultApplication(sAppName, dlg.getCheckBoxStateAsBoolean("UseDefault"));
        }
        return true;
    }

    private boolean autoConfigure(DialogAccess dlg) {
        String sOsName = System.getProperty("os.name");
        String sOsVersion = System.getProperty("os.version");
        String sOsArch = System.getProperty("os.arch");
        StringBuilder info = new StringBuilder();
        info.append(Messages.getString("ApplicationsDialog.configresults") + ":\n\n");
        info.append(Messages.getString("ApplicationsDialog.systemident") + " " + sOsName + " " + Messages.getString("ApplicationsDialog.version") + " " + sOsVersion + " (" + sOsArch + ")\n\n");
        if (sOsName.startsWith("Windows")) {
            this.autoConfigureWindows(dlg, info);
        } else {
            this.autoConfigureUnix(dlg, info);
        }
        this.displayAutoConfigInfo(info.toString());
        this.changeApplication(dlg);
        return true;
    }

    private void displayAutoConfigInfo(String sText) {
        XDialog xDialog = this.getDialog("W2LDialogs2.AutoConfigInfo");
        if (xDialog != null) {
            DialogAccess info = new DialogAccess(xDialog);
            info.setTextFieldText("Info", sText);
            xDialog.execute();
            xDialog.endExecute();
        }
    }

    private XDialog getDialog(String sDialogName) {
        XMultiComponentFactory xMCF = this.xContext.getServiceManager();
        try {
            Object provider = xMCF.createInstanceWithContext("com.sun.star.awt.DialogProvider2", this.xContext);
            XDialogProvider2 xDialogProvider = (XDialogProvider2)UnoRuntime.queryInterface(XDialogProvider2.class, (Object)provider);
            String sDialogUrl = "vnd.sun.star.script:" + sDialogName + "?location=application";
            return xDialogProvider.createDialogWithHandler(sDialogUrl, (Object)this);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getSelectedAppName(DialogAccess dlg) {
        short nItem = dlg.getListBoxSelectedItem("Application");
        switch (nItem) {
            case 0: {
                return "LaTeX";
            }
            case 1: {
                return "PdfLaTeX";
            }
            case 2: {
                return "XeLaTeX";
            }
            case 3: {
                return "Dvips";
            }
            case 4: {
                return "BibTeX";
            }
            case 5: {
                return "Makeindex";
            }
            case 6: {
                return "DVIViewer";
            }
            case 7: {
                return "PdfViewer";
            }
            case 8: {
                return "PostscriptViewer";
            }
        }
        return "???";
    }

    private void autoConfigureWindows(DialogAccess dlg, StringBuilder info) {
        String sMikTeXPath = this.getMikTeXPath();
        boolean bFoundTexworks = false;
        if (sMikTeXPath != null) {
            info.append(Messages.getString("ApplicationsDialog.foundmiktex") + "\n");
            this.configureMikTeX(sMikTeXPath, "LaTeX", "latex", "--interaction=batchmode %s", info, true);
            this.configureMikTeX(sMikTeXPath, "PdfLaTeX", "pdflatex", "--interaction=batchmode %s", info, true);
            this.configureMikTeX(sMikTeXPath, "XeLaTeX", "xelatex", "--interaction=batchmode %s", info, true);
            this.configureMikTeX(sMikTeXPath, "Dvips", "dvips", "%s", info, true);
            this.configureMikTeX(sMikTeXPath, "BibTeX", "bibtex", "%s", info, true);
            this.configureMikTeX(sMikTeXPath, "Makeindex", "makeindex", "%s", info, true);
            this.configureMikTeX(sMikTeXPath, "DVIViewer", "yap", "--single-instance %s", info, true);
            this.externalApps.setUseDefaultApplication("DVIViewer", false);
            bFoundTexworks = this.configureMikTeX(sMikTeXPath, "PdfViewer", "texworks", "%s", info, true);
        } else {
            info.append(Messages.getString("ApplicationsDialog.failedtofindmiktex") + "\n");
            info.append(Messages.getString("ApplicationsDialog.miktexdefaultconfig") + "\n");
            this.externalApps.setApplication("LaTeX", "latex", "--interaction=batchmode %s");
            this.externalApps.setApplication("PdfLaTeX", "pdflatex", "--interaction=batchmode %s");
            this.externalApps.setApplication("XeLaTeX", "xelatex", "--interaction=batchmode %s");
            this.externalApps.setApplication("Dvips", "dvips", "%s");
            this.externalApps.setApplication("BibTeX", "bibtex", "%s");
            this.externalApps.setApplication("Makeindex", "makeindex", "%s");
            this.externalApps.setUseDefaultApplication("DVIViewer", true);
        }
        this.externalApps.setUseDefaultApplication("PdfViewer", !bFoundTexworks);
        info.append("\n");
        String sGsview = this.getGsviewPath();
        if (sGsview != null) {
            info.append(Messages.getString("ApplicationsDialog.foundgsview") + " - " + Messages.getString("ApplicationsDialog.ok") + "\n");
            this.externalApps.setApplication("PostscriptViewer", sGsview, "-e \"%s\"");
            if (!bFoundTexworks) {
                this.externalApps.setApplication("PdfViewer", sGsview, "-e \"%s\"");
                this.externalApps.setUseDefaultApplication("PdfViewer", false);
            }
        } else {
            if (!bFoundTexworks) {
                info.append(Messages.getString("ApplicationsDialog.pdfdefaultviewer") + "\n");
            }
            info.append(Messages.getString("ApplicationsDialog.psdefaultviewer") + "\n");
        }
        this.externalApps.setUseDefaultApplication("PostscriptViewer", sGsview != null);
    }

    private String getMikTeXPath() {
        String[] sPaths;
        for (String s : sPaths = System.getenv("PATH").split(";")) {
            if (s.toLowerCase().indexOf("miktex") <= -1 || !this.containsExecutable(s, "latex.exe")) continue;
            return s;
        }
        for (String s : sPaths) {
            if (!this.containsExecutable(s, "latex.exe")) continue;
            return s;
        }
        return null;
    }

    private String getGsviewPath() {
        String sProgramFiles = System.getenv("ProgramFiles");
        if (sProgramFiles != null && this.containsExecutable(sProgramFiles + "\\ghostgum\\gsview", "gsview32.exe")) {
            return sProgramFiles + "\\ghostgum\\gsview\\gsview32.exe";
        }
        return null;
    }

    private boolean containsExecutable(String sPath, String sExecutable) {
        File dir = new File(sPath);
        if (dir.exists() && dir.canRead()) {
            File exe = new File(dir, sExecutable);
            return exe.exists();
        }
        return false;
    }

    private boolean configureMikTeX(String sPath, String sName, String sAppName, String sArguments, StringBuilder info, boolean bRequired) {
        File app = new File(new File(sPath), sAppName + ".exe");
        if (app.exists()) {
            this.externalApps.setApplication(sName, sAppName, sArguments);
            info.append("  " + Messages.getString("ApplicationsDialog.found") + " " + sName + ": " + sAppName + " - " + Messages.getString("ApplicationsDialog.ok") + "\n");
            return true;
        }
        if (bRequired) {
            this.externalApps.setApplication(sName, "???", "???");
            info.append("  " + Messages.getString("ApplicationsDialog.failedtofind") + " " + sName + "\n");
        }
        return false;
    }

    private void autoConfigureUnix(DialogAccess dlg, StringBuilder info) {
        this.configureApp("LaTeX", "latex", "--interaction=batchmode %s", info);
        this.configureApp("PdfLaTeX", "pdflatex", "--interaction=batchmode %s", info);
        this.configureApp("XeLaTeX", "xelatex", "--interaction=batchmode %s", info);
        this.configureApp("Dvips", "dvips", "%s", info);
        this.configureApp("BibTeX", "bibtex", "%s", info);
        this.configureApp("Makeindex", "makeindex", "%s", info);
        String[] sDviViewers = new String[]{"evince", "okular", "xdvi"};
        this.configureViewer("DVIViewer", sDviViewers, "%s", info);
        String[] sPdfViewers = new String[]{"evince", "okular", "xpdf"};
        this.configureViewer("PdfViewer", sPdfViewers, "%s", info);
        String[] sPsViewers = new String[]{"evince", "okular", "ghostview"};
        this.configureViewer("PostscriptViewer", sPsViewers, "%s", info);
    }

    private boolean hasApp(String sAppName) {
        try {
            Vector<String> command = new Vector<String>();
            command.add("which");
            command.add(sAppName);
            ProcessBuilder pb = new ProcessBuilder(command);
            Process proc = pb.start();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
            errorGobbler.start();
            outputGobbler.start();
            return proc.waitFor() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean configureApp(String sName, String sAppName, String sArguments, StringBuilder info) {
        if (this.hasApp(sAppName)) {
            this.externalApps.setApplication(sName, sAppName, sArguments);
            this.externalApps.setUseDefaultApplication(sName, false);
            if (info != null) {
                info.append(Messages.getString("ApplicationsDialog.found") + " " + sAppName + " - " + Messages.getString("ApplicationsDialog.ok") + "\n");
            }
            return true;
        }
        this.externalApps.setApplication(sName, "???", "???");
        this.externalApps.setUseDefaultApplication(sName, false);
        if (info != null) {
            info.append(Messages.getString("ApplicationsDialog.failedtofind") + " " + sAppName + "\n");
        }
        return false;
    }

    private boolean configureViewer(String sName, String[] sAppNames, String sArguments, StringBuilder info) {
        for (String sAppName : sAppNames) {
            if (!this.configureApp(sName, sAppName, sArguments, null)) continue;
            info.append(Messages.getString("ApplicationsDialog.found") + " " + ExternalApps.getUIAppName(sName) + ": " + sAppName + " - " + Messages.getString("ApplicationsDialog.ok") + "\n");
            return true;
        }
        this.externalApps.setUseDefaultApplication(sName, true);
        info.append(Messages.getString("ApplicationsDialog.usingdefaultapp") + " " + ExternalApps.getUIAppName(sName) + "\n");
        return true;
    }
}

