/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.diagram;

import java.awt.Point;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Note;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Pair;

public class NoteManager {
    private final LinkedList<Note> notes;
    private final Map<Integer, List<Message>> messageAssociation;
    private final Map<Integer, List<Pair<Lifeline, Integer>>> eventAssociation;
    private final Map<String, Note> pendingNotes;
    private int freeNoteNumber;
    private final SequenceDiagram diagram;

    public NoteManager(SequenceDiagram diagram) {
        this.diagram = diagram;
        this.notes = new LinkedList();
        this.messageAssociation = new HashMap<Integer, List<Message>>();
        this.eventAssociation = new HashMap<Integer, List<Pair<Lifeline, Integer>>>();
        this.freeNoteNumber = 0;
        this.pendingNotes = new HashMap<String, Note>();
    }

    public void associateMessage(int number, Message msg) {
        List<Message> msgs = this.messageAssociation.get(number);
        if (msgs == null) {
            msgs = new LinkedList<Message>();
            this.messageAssociation.put(number, msgs);
        }
        msgs.add(msg);
    }

    public void computeArrowAssociations() {
        for (Note description : this.notes) {
            List<Pair<Lifeline, Integer>> pairs;
            List<Message> msgs = this.messageAssociation.get(description.getNumber());
            if (msgs != null) {
                for (Message msg : msgs) {
                    if (msg.getArrow() == null) continue;
                    description.addTarget(msg.getArrow().getAnchor());
                }
            }
            if ((pairs = this.eventAssociation.get(description.getNumber())) == null) continue;
            for (Pair<Lifeline, Integer> pair : pairs) {
                int x = pair.getFirst().getView().getLeft() + pair.getFirst().getView().getWidth() / 2;
                Point p = new Point(x, pair.getSecond());
                description.addTarget(p);
            }
        }
    }

    public int getNextFreeNoteNumber() {
        return this.freeNoteNumber;
    }

    private void associateEvent(Lifeline line, int descriptionNumber) {
        List<Pair<Lifeline, Integer>> pairs = this.eventAssociation.get(descriptionNumber);
        if (pairs == null) {
            pairs = new LinkedList<Pair<Lifeline, Integer>>();
            this.eventAssociation.put(descriptionNumber, pairs);
        }
        pairs.add(new Pair<Lifeline, Integer>(line, this.diagram.getVerticalPosition()));
    }

    void closeNote(String lifeline) {
        Note note = this.pendingNotes.get(lifeline);
        if (note != null) {
            int diff = note.getTop() + note.getHeight() - this.diagram.getVerticalPosition();
            if (diff > 0) {
                this.diagram.extendLifelines(diff);
            }
            this.pendingNotes.remove(lifeline);
        }
    }

    public boolean step() throws SyntaxError {
        Note note = this.diagram.getDataProvider().getNote();
        if (note != null) {
            this.freeNoteNumber = Math.max(this.freeNoteNumber, note.getNumber() + 1);
            this.diagram.getPaintDevice().append(note);
            this.notes.add(note);
            this.closeNote(note.getLocation().getName());
            this.diagram.getFragmentManager().openFragments();
            this.diagram.getPaintDevice().announce(note.getHeight());
            note.setTop(this.diagram.getVerticalPosition());
            if (note.isConsuming()) {
                this.diagram.extendLifelines(note.getHeight());
            } else {
                this.pendingNotes.put(note.getLocation().getName(), note);
            }
            if (this.diagram.getDataProvider().getState() != null) {
                this.diagram.addToStateMap(note, this.diagram.getDataProvider().getState());
            }
            this.diagram.getFragmentManager().clearLabels();
            return true;
        }
        Pair<Lifeline, Integer> eventAssoc = this.diagram.getDataProvider().getEventAssociation();
        if (eventAssoc != null) {
            this.associateEvent(eventAssoc.getFirst(), eventAssoc.getSecond());
            return true;
        }
        return false;
    }
}

