/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;

public class FontConfigurator<C extends DataObject>
extends Configurator<Font, C>
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -5774694431117789385L;
    private static final int strut = 5;
    private JComboBox nameComboBox;
    private JSpinner sizeSpinner;
    private JCheckBox italic;
    private JCheckBox bold;
    private JLabel sampleLabel;
    private JLabel label;

    public FontConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridLayout(2, 1));
        JPanel top = new JPanel();
        this.add(top);
        top.setLayout(new BoxLayout(top, 0));
        this.label = new JLabel(this.getProperty().getWriteMethod().getAnnotation(Adjustable.class).info() + ":");
        this.label.setHorizontalAlignment(11);
        this.label.setPreferredSize(new Dimension(90, this.label.getPreferredSize().height));
        this.label.setHorizontalAlignment(4);
        top.add(this.label);
        top.add(Box.createRigidArea(new Dimension(5, 1)));
        this.nameComboBox = new JComboBox<String>(FontConfigurator.getAllFontFamilyNames());
        top.add(this.nameComboBox);
        SpinnerNumberModel model = new SpinnerNumberModel(12, 1, 128, 1);
        this.sizeSpinner = new JSpinner(model);
        top.add(Box.createRigidArea(new Dimension(5, 1)));
        top.add(this.sizeSpinner);
        top.add(Box.createRigidArea(new Dimension(5, 1)));
        this.italic = new JCheckBox("italic");
        this.bold = new JCheckBox("bold");
        top.add(this.italic);
        top.add(this.bold);
        this.sampleLabel = new JLabel();
        this.add(this.sampleLabel);
        this.sizeSpinner.addChangeListener(this);
        this.nameComboBox.addActionListener(this);
        this.italic.addActionListener(this);
        this.bold.addActionListener(this);
    }

    private static String[] getAllFontFamilyNames() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getAvailableFontFamilyNames();
    }

    @Override
    protected void refresh(Font value) {
        this.nameComboBox.setSelectedItem(value.getFamily());
        this.sizeSpinner.setValue(value.getSize());
        this.italic.setSelected(false);
        this.bold.setSelected(false);
        switch (value.getStyle()) {
            case 1: {
                this.bold.setSelected(true);
                break;
            }
            case 2: {
                this.italic.setSelected(true);
                break;
            }
            case 3: {
                this.italic.setSelected(true);
                this.bold.setSelected(true);
            }
        }
        this.sampleLabel.setFont(this.getSelectedFont());
        this.sampleLabel.setText("The quick brown fox jumps over the lazy dog.");
    }

    private Font getSelectedFont() {
        String name = (String)this.nameComboBox.getSelectedItem();
        int size = (Integer)this.sizeSpinner.getValue();
        int style = (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0);
        Font font = new Font(name, style, size);
        return font;
    }

    @Override
    public void _actionPerformed(ActionEvent e) {
        Font font = this.getSelectedFont();
        this.applyValue(font);
        this.sampleLabel.setFont(font);
        this.sampleLabel.setText("The quick brown fox jumps over the lazy dog.");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.actionPerformed(null);
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.nameComboBox.setEnabled(enabled);
        this.sizeSpinner.setEnabled(enabled);
        this.italic.setEnabled(enabled);
        this.bold.setEnabled(enabled);
        this.label.setEnabled(enabled);
        this.sampleLabel.setEnabled(enabled);
    }

    @Override
    public int getLabelWidth() {
        return this.label.getPreferredSize().width;
    }

    @Override
    public void setLabelWidth(int width) {
        this.label.setPreferredSize(new Dimension(width, this.label.getPreferredSize().height));
    }

    @Override
    public void focus() {
        this.nameComboBox.requestFocusInWindow();
    }
}

