/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util.tree;

import java.util.LinkedList;
import net.sf.sdedit.util.tree.TraversalControl;
import net.sf.sdedit.util.tree.Tree;

public class LevelTraversal<T> {
    private TraversalControl<T> traversalControl;

    public LevelTraversal(TraversalControl<T> traversalControl) {
        this.traversalControl = traversalControl;
    }

    public void traverse(Tree<T> tree) {
        LinkedList<Node> queue = new LinkedList<Node>();
        for (Object t : tree.getChildren(null)) {
            if (!this.traversalControl.doTraverse(t, 0)) continue;
            Node node = new Node();
            node.level = 0;
            node.t = t;
            queue.addFirst(node);
        }
        while (!queue.isEmpty()) {
            Node node = (Node)queue.removeLast();
            this.traversalControl.beginTraversal(node.t, node.level);
            boolean leaf = true;
            for (Object t : tree.getChildren(node.t)) {
                if (!this.traversalControl.doTraverse(t, node.level + 1)) continue;
                leaf = false;
                Node newNode = new Node();
                newNode.level = node.level + 1;
                newNode.t = t;
                queue.addFirst(node);
            }
            this.traversalControl.endTraversal(node.t, leaf);
        }
    }

    private class Node {
        int level;
        T t;

        private Node() {
        }
    }
}

