/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.util.IndentingWriter;

public class LabelMethodItem
extends MethodItem {
    private final BaksmaliOptions options;
    private final String labelPrefix;
    private int labelSequence;

    public LabelMethodItem(@Nonnull BaksmaliOptions options, int codeAddress, @Nonnull String labelPrefix) {
        super(codeAddress);
        this.options = options;
        this.labelPrefix = labelPrefix;
    }

    @Override
    public double getSortOrder() {
        return 0.0;
    }

    @Override
    public int compareTo(MethodItem methodItem) {
        int result = super.compareTo(methodItem);
        if (result == 0 && methodItem instanceof LabelMethodItem) {
            result = this.labelPrefix.compareTo(((LabelMethodItem)methodItem).labelPrefix);
        }
        return result;
    }

    public int hashCode() {
        return this.getCodeAddress();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LabelMethodItem)) {
            return false;
        }
        return this.compareTo((MethodItem)o) == 0;
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(58);
        writer.write(this.labelPrefix);
        if (this.options.sequentialLabels) {
            writer.printUnsignedLongAsHex(this.labelSequence);
        } else {
            writer.printUnsignedLongAsHex(this.getLabelAddress());
        }
        return true;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public int getLabelAddress() {
        return this.getCodeAddress();
    }

    public int getLabelSequence() {
        return this.labelSequence;
    }

    public void setLabelSequence(int labelSequence) {
        this.labelSequence = labelSequence;
    }
}

