/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.ParameterParser;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItem;
import org.apache.tomcat.util.http.parser.HttpParser;

public class ApplicationPart
implements Part {
    private final FileItem fileItem;
    private final File location;

    public ApplicationPart(FileItem fileItem, File file) {
        this.fileItem = fileItem;
        this.location = file;
    }

    public void delete() throws IOException {
        this.fileItem.delete();
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public String getHeader(String string) {
        if (this.fileItem instanceof DiskFileItem) {
            return this.fileItem.getHeaders().getHeader(string);
        }
        return null;
    }

    public Collection<String> getHeaderNames() {
        if (this.fileItem instanceof DiskFileItem) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            Iterator iterator = this.fileItem.getHeaders().getHeaderNames();
            while (iterator.hasNext()) {
                linkedHashSet.add((String)iterator.next());
            }
            return linkedHashSet;
        }
        return Collections.emptyList();
    }

    public Collection<String> getHeaders(String string) {
        if (this.fileItem instanceof DiskFileItem) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            Iterator iterator = this.fileItem.getHeaders().getHeaders(string);
            while (iterator.hasNext()) {
                linkedHashSet.add((String)iterator.next());
            }
            return linkedHashSet;
        }
        return Collections.emptyList();
    }

    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    public String getName() {
        return this.fileItem.getFieldName();
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public void write(String string) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.location, string);
        }
        try {
            this.fileItem.write(file);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public String getString(String string) throws UnsupportedEncodingException {
        return this.fileItem.getString(string);
    }

    public String getSubmittedFileName() {
        String string;
        String string2 = null;
        String string3 = this.getHeader("Content-Disposition");
        if (string3 != null && ((string = string3.toLowerCase(Locale.ENGLISH)).startsWith("form-data") || string.startsWith("attachment"))) {
            ParameterParser parameterParser = new ParameterParser();
            parameterParser.setLowerCaseNames(true);
            Map map = parameterParser.parse(string3, ';');
            if (map.containsKey("filename")) {
                string2 = (String)map.get("filename");
                string2 = string2 != null ? (string2.indexOf(92) > -1 ? HttpParser.unquote((String)string2.trim()) : string2.trim()) : "";
            }
        }
        return string2;
    }
}

