/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.util.HashMap;
import java.util.Map;
import javax.naming.directory.DirContext;
import org.apache.catalina.CredentialHandler;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterDeployer;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.storeconfig.IStoreFactory;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.coyote.UpgradeProtocol;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.res.StringManager;

public class StoreRegistry {
    private static Log log = LogFactory.getLog(StoreRegistry.class);
    private static StringManager sm = StringManager.getManager(StoreRegistry.class);
    private Map<String, StoreDescription> descriptors = new HashMap<String, StoreDescription>();
    private String encoding = "UTF-8";
    private String name;
    private String version;
    private static Class<?>[] interfaces = new Class[]{CatalinaCluster.class, ChannelSender.class, ChannelReceiver.class, Channel.class, MembershipService.class, ClusterDeployer.class, Realm.class, Manager.class, DirContext.class, LifecycleListener.class, Valve.class, ClusterListener.class, MessageListener.class, DataSender.class, ChannelInterceptor.class, Member.class, WebResourceRoot.class, WebResourceSet.class, CredentialHandler.class, UpgradeProtocol.class, CookieProcessor.class};

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public StoreDescription findDescription(String string) {
        StoreDescription storeDescription;
        if (log.isDebugEnabled()) {
            log.debug((Object)("search descriptor " + string));
        }
        if ((storeDescription = this.descriptors.get(string)) == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string, true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error((Object)sm.getString("registry.loadClassFailed", new Object[]{string}), (Throwable)classNotFoundException);
            }
            if (clazz != null) {
                storeDescription = this.descriptors.get(clazz.getName());
                for (int i = 0; storeDescription == null && i < interfaces.length; ++i) {
                    if (!interfaces[i].isAssignableFrom(clazz)) continue;
                    storeDescription = this.descriptors.get(interfaces[i].getName());
                }
            }
        }
        if (log.isDebugEnabled()) {
            if (storeDescription != null) {
                log.debug((Object)("find descriptor " + string + "#" + storeDescription.getTag() + "#" + storeDescription.getStoreFactoryClass()));
            } else {
                log.debug((Object)("Can't find descriptor for key " + string));
            }
        }
        return storeDescription;
    }

    public StoreDescription findDescription(Class<?> clazz) {
        return this.findDescription(clazz.getName());
    }

    public IStoreFactory findStoreFactory(String string) {
        StoreDescription storeDescription = this.findDescription(string);
        if (storeDescription != null) {
            return storeDescription.getStoreFactory();
        }
        return null;
    }

    public IStoreFactory findStoreFactory(Class<?> clazz) {
        return this.findStoreFactory(clazz.getName());
    }

    public void registerDescription(StoreDescription storeDescription) {
        String string = storeDescription.getId();
        if (string == null || string.isEmpty()) {
            string = storeDescription.getTagClass();
        }
        this.descriptors.put(string, storeDescription);
        if (log.isDebugEnabled()) {
            log.debug((Object)("register store descriptor " + string + "#" + storeDescription.getTag() + "#" + storeDescription.getTagClass()));
        }
    }

    public StoreDescription unregisterDescription(StoreDescription storeDescription) {
        String string = storeDescription.getId();
        if (string == null || "".equals(string)) {
            string = storeDescription.getTagClass();
        }
        return this.descriptors.remove(string);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }
}

