/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.http;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.NoBodyResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;

public abstract class HttpServlet
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String LSTRING_FILE = "jakarta.servlet.http.LocalStrings";
    private static final ResourceBundle lStrings = ResourceBundle.getBundle("jakarta.servlet.http.LocalStrings");
    private final Object cachedAllowHeaderValueLock = new Object();
    private volatile String cachedAllowHeaderValue = null;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = lStrings.getString("http.method_get_not_supported");
        this.sendMethodNotAllowed(httpServletRequest, httpServletResponse, string);
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return -1L;
    }

    protected void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (DispatcherType.INCLUDE.equals((Object)httpServletRequest.getDispatcherType())) {
            this.doGet(httpServletRequest, httpServletResponse);
        } else {
            NoBodyResponse noBodyResponse = new NoBodyResponse(httpServletResponse);
            this.doGet(httpServletRequest, noBodyResponse);
            noBodyResponse.setContentLength();
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = lStrings.getString("http.method_post_not_supported");
        this.sendMethodNotAllowed(httpServletRequest, httpServletResponse, string);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = lStrings.getString("http.method_put_not_supported");
        this.sendMethodNotAllowed(httpServletRequest, httpServletResponse, string);
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = lStrings.getString("http.method_delete_not_supported");
        this.sendMethodNotAllowed(httpServletRequest, httpServletResponse, string);
    }

    private void sendMethodNotAllowed(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2 = httpServletRequest.getProtocol();
        if (string2.length() == 0 || string2.endsWith("0.9") || string2.endsWith("1.0")) {
            httpServletResponse.sendError(400, string);
        } else {
            httpServletResponse.sendError(405, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCachedAllowHeaderValue() {
        if (this.cachedAllowHeaderValue == null) {
            Object object = this.cachedAllowHeaderValueLock;
            synchronized (object) {
                if (this.cachedAllowHeaderValue == null) {
                    Method[] methodArray = HttpServlet.getAllDeclaredMethods(this.getClass());
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    block15: for (Method method : methodArray) {
                        switch (method.getName()) {
                            case "doGet": {
                                bl = true;
                                bl2 = true;
                                continue block15;
                            }
                            case "doPost": {
                                bl3 = true;
                                continue block15;
                            }
                            case "doPut": {
                                bl4 = true;
                                continue block15;
                            }
                            case "doDelete": {
                                bl5 = true;
                                continue block15;
                            }
                        }
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    if (bl) {
                        stringBuilder.append(METHOD_GET);
                        stringBuilder.append(", ");
                    }
                    if (bl2) {
                        stringBuilder.append(METHOD_HEAD);
                        stringBuilder.append(", ");
                    }
                    if (bl3) {
                        stringBuilder.append(METHOD_POST);
                        stringBuilder.append(", ");
                    }
                    if (bl4) {
                        stringBuilder.append(METHOD_PUT);
                        stringBuilder.append(", ");
                    }
                    if (bl5) {
                        stringBuilder.append(METHOD_DELETE);
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(METHOD_OPTIONS);
                    this.cachedAllowHeaderValue = stringBuilder.toString();
                }
            }
        }
        return this.cachedAllowHeaderValue;
    }

    private static Method[] getAllDeclaredMethods(Class<?> clazz) {
        if (clazz.equals(HttpServlet.class)) {
            return null;
        }
        Method[] methodArray = HttpServlet.getAllDeclaredMethods(clazz.getSuperclass());
        Method[] methodArray2 = clazz.getDeclaredMethods();
        if (methodArray != null && methodArray.length > 0) {
            Method[] methodArray3 = new Method[methodArray.length + methodArray2.length];
            System.arraycopy(methodArray, 0, methodArray3, 0, methodArray.length);
            System.arraycopy(methodArray2, 0, methodArray3, methodArray.length, methodArray2.length);
            methodArray2 = methodArray3;
        }
        return methodArray2;
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getCachedAllowHeaderValue();
        if (TomcatHack.getAllowTrace(httpServletRequest)) {
            string = string.length() == 0 ? METHOD_TRACE : string + ", " + METHOD_TRACE;
        }
        httpServletResponse.setHeader("Allow", string);
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = "\r\n";
        StringBuilder stringBuilder = new StringBuilder("TRACE ").append(httpServletRequest.getRequestURI()).append(" ").append(httpServletRequest.getProtocol());
        Enumeration<String> enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            stringBuilder.append(string).append((String)object).append(": ").append(httpServletRequest.getHeader((String)object));
        }
        stringBuilder.append(string);
        int n = stringBuilder.length();
        httpServletResponse.setContentType("message/http");
        httpServletResponse.setContentLength(n);
        object = httpServletResponse.getOutputStream();
        ((ServletOutputStream)object).print(stringBuilder.toString());
        ((OutputStream)object).close();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (string.equals(METHOD_GET)) {
            long l = this.getLastModified(httpServletRequest);
            if (l == -1L) {
                this.doGet(httpServletRequest, httpServletResponse);
            } else {
                long l2;
                try {
                    l2 = httpServletRequest.getDateHeader(HEADER_IFMODSINCE);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    l2 = -1L;
                }
                if (l2 < l / 1000L * 1000L) {
                    this.maybeSetLastModified(httpServletResponse, l);
                    this.doGet(httpServletRequest, httpServletResponse);
                } else {
                    httpServletResponse.setStatus(304);
                }
            }
        } else if (string.equals(METHOD_HEAD)) {
            long l = this.getLastModified(httpServletRequest);
            this.maybeSetLastModified(httpServletResponse, l);
            this.doHead(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_POST)) {
            this.doPost(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_PUT)) {
            this.doPut(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_DELETE)) {
            this.doDelete(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_OPTIONS)) {
            this.doOptions(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_TRACE)) {
            this.doTrace(httpServletRequest, httpServletResponse);
        } else {
            String string2 = lStrings.getString("http.method_not_implemented");
            Object[] objectArray = new Object[]{string};
            string2 = MessageFormat.format(string2, objectArray);
            httpServletResponse.sendError(501, string2);
        }
    }

    private void maybeSetLastModified(HttpServletResponse httpServletResponse, long l) {
        if (httpServletResponse.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (l >= 0L) {
            httpServletResponse.setDateHeader(HEADER_LASTMOD, l);
        }
    }

    @Override
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletResponse httpServletResponse;
        HttpServletRequest httpServletRequest;
        try {
            httpServletRequest = (HttpServletRequest)servletRequest;
            httpServletResponse = (HttpServletResponse)servletResponse;
        }
        catch (ClassCastException classCastException) {
            throw new ServletException(lStrings.getString("http.non_http"));
        }
        this.service(httpServletRequest, httpServletResponse);
    }

    private static class TomcatHack {
        private static final Class<?> REQUEST_FACADE_CLAZZ;
        private static final Method GET_ALLOW_TRACE;

        private TomcatHack() {
        }

        public static boolean getAllowTrace(HttpServletRequest httpServletRequest) {
            if (REQUEST_FACADE_CLAZZ != null && GET_ALLOW_TRACE != null && REQUEST_FACADE_CLAZZ.isAssignableFrom(httpServletRequest.getClass())) {
                try {
                    return (Boolean)GET_ALLOW_TRACE.invoke((Object)httpServletRequest, (Object[])null);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            return true;
        }

        static {
            Method method = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName("org.apache.catalina.connector.RequestFacade");
                method = clazz.getMethod("getAllowTrace", null);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
            REQUEST_FACADE_CLAZZ = clazz;
            GET_ALLOW_TRACE = method;
        }
    }
}

