/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;

class AssertNotEquals {
    private AssertNotEquals() {
    }

    static void assertNotEquals(byte unexpected, byte actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(byte unexpected, byte actual, String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(byte unexpected, byte actual, Supplier<String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    static void assertNotEquals(short unexpected, short actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(short unexpected, short actual, String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(short unexpected, short actual, Supplier<String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    static void assertNotEquals(int unexpected, int actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(int unexpected, int actual, String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(int unexpected, int actual, Supplier<String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    static void assertNotEquals(long unexpected, long actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(long unexpected, long actual, String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(long unexpected, long actual, Supplier<String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    static void assertNotEquals(float unexpected, float actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(float unexpected, float actual, String message) {
        if (AssertionUtils.floatsAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(Float.valueOf(actual), message);
        }
    }

    static void assertNotEquals(float unexpected, float actual, Supplier<String> messageSupplier) {
        if (AssertionUtils.floatsAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(Float.valueOf(actual), AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    static void assertNotEquals(float unexpected, float actual, float delta) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta, (String)null);
    }

    static void assertNotEquals(float unexpected, float actual, float delta, String message) {
        if (AssertionUtils.floatsAreEqual(unexpected, actual, delta)) {
            AssertNotEquals.failEqual(Float.valueOf(actual), message);
        }
    }

    static void assertNotEquals(float unexpected, float actual, float delta, Supplier<String> messageSupplier) {
        if (AssertionUtils.floatsAreEqual(unexpected, actual, delta)) {
            AssertNotEquals.failEqual(Float.valueOf(actual), AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    static void assertNotEquals(double unexpected, double actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(double unexpected, double actual, String message) {
        if (AssertionUtils.doublesAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(double unexpected, double actual, Supplier<String> messageSupplier) {
        if (AssertionUtils.doublesAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    static void assertNotEquals(double unexpected, double actual, double delta) {
        AssertNotEquals.assertNotEquals(unexpected, actual, delta, (String)null);
    }

    static void assertNotEquals(double unexpected, double actual, double delta, String message) {
        if (AssertionUtils.doublesAreEqual(unexpected, actual, delta)) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(double unexpected, double actual, double delta, Supplier<String> messageSupplier) {
        if (AssertionUtils.doublesAreEqual(unexpected, actual, delta)) {
            AssertNotEquals.failEqual(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    static void assertNotEquals(char unexpected, char actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(char unexpected, char actual, String message) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(Character.valueOf(actual), message);
        }
    }

    static void assertNotEquals(char unexpected, char actual, Supplier<String> messageSupplier) {
        if (unexpected == actual) {
            AssertNotEquals.failEqual(Character.valueOf(actual), AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    static void assertNotEquals(Object unexpected, Object actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual, (String)null);
    }

    static void assertNotEquals(Object unexpected, Object actual, String message) {
        if (AssertionUtils.objectsAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(actual, message);
        }
    }

    static void assertNotEquals(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        if (AssertionUtils.objectsAreEqual(unexpected, actual)) {
            AssertNotEquals.failEqual(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    private static void failEqual(Object actual, String message) {
        AssertionUtils.fail(AssertionUtils.buildPrefix(message) + "expected: not equal but was: <" + actual + ">");
    }
}

