/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

final class ExtensionUtils {
    private static final Predicate<Field> isStaticExtension = new IsStaticExtensionField();
    private static final Predicate<Field> isNonStaticExtension = new IsNonStaticExtensionField();
    private static final Comparator<Field> orderComparator = (field1, field2) -> Integer.compare(ExtensionUtils.getOrder(field1), ExtensionUtils.getOrder(field2));

    private ExtensionUtils() {
    }

    static ExtensionRegistry populateNewExtensionRegistryFromExtendWithAnnotation(ExtensionRegistry parentRegistry, AnnotatedElement annotatedElement) {
        Preconditions.notNull((Object)annotatedElement, (String)"AnnotatedElement must not be null");
        Preconditions.notNull((Object)parentRegistry, (String)"Parent ExtensionRegistry must not be null");
        List<Class<? extends Extension>> extensionTypes = AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)annotatedElement, ExtendWith.class).stream().map(ExtendWith::value).flatMap(Arrays::stream).collect(Collectors.toList());
        return ExtensionRegistry.createRegistryFrom(parentRegistry, extensionTypes);
    }

    static void registerExtensionsFromFields(ExtensionRegistry registry, Class<?> clazz, Object instance) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        Preconditions.notNull((Object)registry, (String)"ExtensionRegistry must not be null");
        Predicate<Field> predicate = instance == null ? isStaticExtension : isNonStaticExtension;
        ArrayList<Field> fields = new ArrayList<Field>(AnnotationUtils.findAnnotatedFields(clazz, RegisterExtension.class, predicate));
        fields.sort(orderComparator);
        fields.forEach(field -> ReflectionUtils.tryToReadFieldValue((Field)field, (Object)instance).ifSuccess(value -> {
            Preconditions.notNull((Object)value, () -> String.format("Failed to register extension via @RegisterExtension field [%s]: field must not be null when evaluated.", field));
            Extension extension = (Extension)value;
            registry.registerExtension(extension, field);
        }));
    }

    private static int getOrder(Field field) {
        return AnnotationUtils.findAnnotation((AnnotatedElement)field, Order.class).map(Order::value).orElse(Integer.MAX_VALUE);
    }

    static class IsStaticExtensionField
    implements Predicate<Field> {
        IsStaticExtensionField() {
        }

        @Override
        public boolean test(Field field) {
            if (!ReflectionUtils.isStatic((Member)field)) {
                return false;
            }
            if (ReflectionUtils.isPrivate((Member)field)) {
                return false;
            }
            return Extension.class.isAssignableFrom(field.getType());
        }
    }

    static class IsNonStaticExtensionField
    implements Predicate<Field> {
        IsNonStaticExtensionField() {
        }

        @Override
        public boolean test(Field field) {
            if (ReflectionUtils.isStatic((Member)field)) {
                return false;
            }
            if (ReflectionUtils.isPrivate((Member)field)) {
                return false;
            }
            return Extension.class.isAssignableFrom(field.getType());
        }
    }
}

