/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Debug;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.jf.baksmali.Adaptors.Debug.DebugMethodItem;
import org.jf.baksmali.Adaptors.Debug.LocalFormatter;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.dexlib2.iface.debug.StartLocal;
import org.jf.util.IndentingWriter;

public class StartLocalMethodItem
extends DebugMethodItem {
    @Nonnull
    private final StartLocal startLocal;
    @Nonnull
    private final RegisterFormatter registerFormatter;

    public StartLocalMethodItem(int codeAddress, int sortOrder, @Nonnull RegisterFormatter registerFormatter, @Nonnull StartLocal startLocal) {
        super(codeAddress, sortOrder);
        this.startLocal = startLocal;
        this.registerFormatter = registerFormatter;
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(".local ");
        this.registerFormatter.writeTo(writer, this.startLocal.getRegister());
        String name = this.startLocal.getName();
        String type = this.startLocal.getType();
        String signature = this.startLocal.getSignature();
        if (name != null || type != null || signature != null) {
            writer.write(", ");
            LocalFormatter.writeLocal(writer, name, type, signature);
        }
        return true;
    }
}

