/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.ui.codearea.CodeArea;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.fife.ui.rsyntaxtextarea.Token;
import org.jetbrains.annotations.Nullable;

public abstract class JNodeMenuAction<T>
extends AbstractAction
implements PopupMenuListener {
    private static final long serialVersionUID = -2600154727884853550L;
    protected final transient CodeArea codeArea;
    @Nullable
    protected transient T node;

    public JNodeMenuAction(String name, CodeArea codeArea) {
        super(name);
        this.codeArea = codeArea;
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    @Nullable
    public abstract T getNodeByOffset(int var1);

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.node = this.getNode();
        this.setEnabled(this.node != null);
    }

    @Nullable
    private T getNode() {
        Point pos = this.codeArea.getMousePosition();
        if (pos != null) {
            Token token = this.codeArea.viewToToken(pos);
            int offset = this.codeArea.adjustOffsetForToken(token);
            return this.getNodeByOffset(offset);
        }
        return null;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

