/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.search;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.codegen.CodeWriter;
import jadx.gui.treemodel.CodeNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.SearchDialog;
import jadx.gui.utils.CodeLinesInfo;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.search.CodeIndex;
import jadx.gui.utils.search.SimpleIndex;
import jadx.gui.utils.search.StringRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextSearchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(TextSearchIndex.class);
    private final JNodeCache nodeCache;
    private final SimpleIndex clsNamesIndex;
    private final SimpleIndex mthSignaturesIndex;
    private final SimpleIndex fldSignaturesIndex;
    private final CodeIndex codeIndex;
    private final List<JavaClass> skippedClasses = new ArrayList<JavaClass>();

    public TextSearchIndex(JNodeCache nodeCache) {
        this.nodeCache = nodeCache;
        this.clsNamesIndex = new SimpleIndex();
        this.mthSignaturesIndex = new SimpleIndex();
        this.fldSignaturesIndex = new SimpleIndex();
        this.codeIndex = new CodeIndex();
    }

    public void indexNames(JavaClass cls) {
        this.clsNamesIndex.put(cls.getFullName(), this.nodeCache.makeFrom(cls));
        for (JavaMethod mth : cls.getMethods()) {
            JNode mthNode = this.nodeCache.makeFrom(mth);
            this.mthSignaturesIndex.put(mthNode.makeDescString(), mthNode);
        }
        for (JavaField fld : cls.getFields()) {
            JNode fldNode = this.nodeCache.makeFrom(fld);
            this.fldSignaturesIndex.put(fldNode.makeDescString(), fldNode);
        }
        for (JavaClass innerCls : cls.getInnerClasses()) {
            this.indexNames(innerCls);
        }
    }

    public void indexCode(JavaClass cls, CodeLinesInfo linesInfo, List<StringRef> lines) {
        try {
            int count = lines.size();
            for (int i = 0; i < count; ++i) {
                StringRef line = lines.get(i);
                int lineLength = line.length();
                if (lineLength == 0 || lineLength == 1 && line.charAt(0) == '}') continue;
                int lineNum = i + 1;
                JavaNode node = linesInfo.getJavaNodeByLine(lineNum);
                JNode nodeAtLine = this.nodeCache.makeFrom(node == null ? cls : node);
                this.codeIndex.put(new CodeNode(nodeAtLine, lineNum, line));
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to index class: {}", (Object)cls, (Object)e);
        }
    }

    public void remove(JavaClass cls) {
        this.clsNamesIndex.removeForCls(cls);
        this.mthSignaturesIndex.removeForCls(cls);
        this.fldSignaturesIndex.removeForCls(cls);
        this.codeIndex.removeForCls(cls);
    }

    public Flowable<JNode> buildSearch(String text, Set<SearchDialog.SearchOptions> options) {
        boolean ignoreCase = options.contains((Object)SearchDialog.SearchOptions.IGNORE_CASE);
        LOG.debug("Building search, ignoreCase: {}", (Object)ignoreCase);
        Flowable result = Flowable.empty();
        if (options.contains((Object)SearchDialog.SearchOptions.CLASS)) {
            result = Flowable.concat((Publisher)result, this.clsNamesIndex.search(text, ignoreCase));
        }
        if (options.contains((Object)SearchDialog.SearchOptions.METHOD)) {
            result = Flowable.concat((Publisher)result, this.mthSignaturesIndex.search(text, ignoreCase));
        }
        if (options.contains((Object)SearchDialog.SearchOptions.FIELD)) {
            result = Flowable.concat((Publisher)result, this.fldSignaturesIndex.search(text, ignoreCase));
        }
        if (options.contains((Object)SearchDialog.SearchOptions.CODE)) {
            if (this.codeIndex.size() > 0) {
                result = Flowable.concat((Publisher)result, this.codeIndex.search(text, ignoreCase));
            }
            if (!this.skippedClasses.isEmpty()) {
                result = Flowable.concat((Publisher)result, this.searchInSkippedClasses(text, ignoreCase));
            }
        }
        return result;
    }

    public Flowable<CodeNode> searchInSkippedClasses(String searchStr, boolean caseInsensitive) {
        return Flowable.create(emitter -> {
            LOG.debug("Skipped code search started: {} ...", (Object)searchStr);
            for (JavaClass javaClass : this.skippedClasses) {
                String code = javaClass.getCode();
                int pos = 0;
                while (pos != -1) {
                    pos = this.searchNext((FlowableEmitter<CodeNode>)emitter, searchStr, javaClass, code, pos, caseInsensitive);
                    if (!emitter.isCancelled()) continue;
                    LOG.debug("Skipped Code search canceled: {}", (Object)searchStr);
                    return;
                }
                if (UiUtils.isFreeMemoryAvailable()) continue;
                LOG.warn("Skipped code search stopped due to memory limit: {}", (Object)UiUtils.memoryInfo());
                emitter.onComplete();
                return;
            }
            LOG.debug("Skipped code search complete: {}, memory usage: {}", (Object)searchStr, (Object)UiUtils.memoryInfo());
            emitter.onComplete();
        }, (BackpressureStrategy)BackpressureStrategy.LATEST);
    }

    private int searchNext(FlowableEmitter<CodeNode> emitter, String text, JavaNode javaClass, String code, int startPos, boolean ignoreCase) {
        int pos = ignoreCase ? StringUtils.indexOfIgnoreCase((CharSequence)code, (CharSequence)text, (int)startPos) : code.indexOf(text, startPos);
        if (pos == -1) {
            return -1;
        }
        int lineStart = 1 + code.lastIndexOf(CodeWriter.NL, pos);
        int lineEnd = code.indexOf(CodeWriter.NL, pos + text.length());
        StringRef line = StringRef.subString(code, lineStart, lineEnd == -1 ? code.length() : lineEnd);
        emitter.onNext((Object)new CodeNode(this.nodeCache.makeFrom(javaClass), -pos, line.trim()));
        return lineEnd;
    }

    public void classCodeIndexSkipped(JavaClass cls) {
        this.skippedClasses.add(cls);
    }

    public int getSkippedCount() {
        return this.skippedClasses.size();
    }
}

