/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttribute;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.Utils;
import java.util.List;

public interface IMethodDetails
extends IAttribute {
    public MethodInfo getMethodInfo();

    public ArgType getReturnType();

    public List<ArgType> getArgTypes();

    public List<ArgType> getTypeParameters();

    public List<ArgType> getThrows();

    public boolean isVarArg();

    default public AType<IMethodDetails> getType() {
        return AType.METHOD_DETAILS;
    }

    @Override
    default public String toAttrString() {
        List<ArgType> throwsList;
        StringBuilder sb = new StringBuilder();
        sb.append("MD:");
        if (Utils.notEmpty(this.getTypeParameters())) {
            sb.append('<');
            sb.append(Utils.listToString(this.getTypeParameters()));
            sb.append(">:");
        }
        sb.append('(');
        sb.append(Utils.listToString(this.getArgTypes()));
        sb.append("):");
        sb.append(this.getReturnType());
        if (this.isVarArg()) {
            sb.append(" VARARG");
        }
        if (Utils.notEmpty(throwsList = this.getThrows())) {
            sb.append(" throws ").append(Utils.listToString(throwsList));
        }
        return sb.toString();
    }
}

