/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.MoveInlineVisitor;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.dex.visitors.typeinference.TypeInferenceVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="ConstructorVisitor", desc="Replace invoke with constructor call", runAfter={SSATransform.class, MoveInlineVisitor.class}, runBefore={TypeInferenceVisitor.class})
public class ConstructorVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        ConstructorVisitor.replaceInvoke(mth);
    }

    private static void replaceInvoke(MethodNode mth) {
        InsnRemover remover = new InsnRemover(mth);
        for (BlockNode block : mth.getBasicBlocks()) {
            remover.setBlock(block);
            int size = block.getInstructions().size();
            for (int i = 0; i < size; ++i) {
                InsnNode insn = block.getInstructions().get(i);
                if (insn.getType() != InsnType.INVOKE) continue;
                ConstructorVisitor.processInvoke(mth, block, i, remover);
            }
            remover.perform();
        }
    }

    private static void processInvoke(MethodNode mth, BlockNode block, int indexInBlock, InsnRemover remover) {
        ConstructorInsn replace;
        InsnNode newInstInsn;
        MethodNode defCo;
        ClassNode parentClass = mth.getParentClass();
        InsnNode insn = block.getInstructions().get(indexInBlock);
        InvokeNode inv = (InvokeNode)insn;
        MethodInfo callMth = inv.getCallMth();
        if (!callMth.isConstructor()) {
            return;
        }
        InsnNode instArgAssignInsn = ((RegisterArg)inv.getArg(0)).getAssignInsn();
        ConstructorInsn co = new ConstructorInsn(mth, inv);
        co.rebindArgs();
        boolean remove = false;
        if (co.isSuper() && (co.getArgsCount() == 0 || parentClass.isEnum())) {
            remove = true;
        } else if (co.isThis() && co.getArgsCount() == 0 && ((defCo = parentClass.searchMethodByShortId(callMth.getShortId())) == null || defCo.isNoCode())) {
            remove = true;
        }
        if (parentClass.isAnonymous() && mth.isDefaultConstructor() && co.isSuper()) {
            remove = true;
        }
        if (remove) {
            remover.addAndUnbind(insn);
            return;
        }
        if (co.isNewInstance() && (newInstInsn = ConstructorVisitor.removeAssignChain(mth, instArgAssignInsn, remover, InsnType.NEW_INSTANCE)) != null) {
            remover.addWithoutUnbind(newInstInsn);
            RegisterArg instArg = newInstInsn.getResult();
            RegisterArg resultArg = co.getResult();
            if (!resultArg.equals(instArg)) {
                for (RegisterArg useArg : new ArrayList<RegisterArg>(instArg.getSVar().getUseList())) {
                    InsnNode parentInsn = useArg.getParentInsn();
                    if (parentInsn == null) continue;
                    parentInsn.replaceArg(useArg, resultArg.duplicate());
                }
            }
        }
        if ((replace = ConstructorVisitor.processConstructor(mth, co)) != null) {
            remover.addAndUnbind(co);
            co = replace;
        }
        BlockUtils.replaceInsn(mth, block, indexInBlock, (InsnNode)co);
    }

    @Nullable
    private static ConstructorInsn processConstructor(MethodNode mth, ConstructorInsn co) {
        MethodNode callMth = mth.root().resolveMethod(co.getCallMth());
        if (callMth == null || !callMth.getAccessFlags().isSynthetic() || !ConstructorVisitor.allArgsNull(co)) {
            return null;
        }
        ClassNode classNode = mth.root().resolveClass(callMth.getParentClass().getClassInfo());
        if (classNode == null) {
            return null;
        }
        RegisterArg instanceArg = co.getResult();
        if (instanceArg == null) {
            return null;
        }
        boolean passThis = instanceArg.isThis();
        String ctrId = "<init>(" + (passThis ? TypeGen.signature(instanceArg.getInitType()) : "") + ")V";
        MethodNode defCtr = classNode.searchMethodByShortId(ctrId);
        if (defCtr == null || defCtr.equals(callMth) || defCtr.getAccessFlags().isSynthetic()) {
            return null;
        }
        ConstructorInsn newInsn = new ConstructorInsn(defCtr.getMethodInfo(), co.getCallType());
        newInsn.setResult(co.getResult().duplicate());
        return newInsn;
    }

    private static boolean allArgsNull(ConstructorInsn insn) {
        for (InsnArg insnArg : insn.getArguments()) {
            if (insnArg.isLiteral()) {
                LiteralArg lit = (LiteralArg)insnArg;
                if (lit.getLiteral() == 0L) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static InsnNode removeAssignChain(MethodNode mth, InsnNode insn, InsnRemover remover, InsnType insnType) {
        if (insn == null) {
            return null;
        }
        InsnType type = insn.getType();
        if (type == insnType) {
            return insn;
        }
        if (insn.isAttrStorageEmpty()) {
            remover.addWithoutUnbind(insn);
        } else {
            BlockUtils.replaceInsn(mth, insn, new InsnNode(InsnType.NOP, 0));
        }
        if (type == InsnType.MOVE) {
            RegisterArg arg = (RegisterArg)insn.getArg(0);
            return ConstructorVisitor.removeAssignChain(mth, arg.getAssignInsn(), remover, insnType);
        }
        return null;
    }
}

