/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.Jadx;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.SplitterBlockAttr;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.ConstInlineVisitor;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.blocksmaker.helpers.FinallyExtractInfo;
import jadx.core.dex.visitors.blocksmaker.helpers.InsnsSlice;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.utils.BlockUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="MarkFinallyVisitor", desc="Search and mark duplicate code generated for finally block", runAfter={SSATransform.class}, runBefore={ConstInlineVisitor.class})
public class MarkFinallyVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(MarkFinallyVisitor.class);

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode() || mth.isNoExceptionHandlers()) {
            return;
        }
        try {
            mth.clearExceptionHandlers();
            for (ExceptionHandler excHandler : mth.getExceptionHandlers()) {
                MarkFinallyVisitor.processExceptionHandler(mth, excHandler);
            }
            mth.clearExceptionHandlers();
        }
        catch (Exception e) {
            LOG.warn("Undo finally extract visitor, mth: {}", (Object)mth, (Object)e);
            try {
                mth.unload();
                mth.load();
                List<IDexTreeVisitor> passes = Jadx.getPassesList(mth.root().getArgs());
                for (IDexTreeVisitor visitor : passes) {
                    if (visitor instanceof MarkFinallyVisitor) break;
                    visitor.init(mth.root());
                    DepthTraversal.visit(visitor, mth);
                }
            }
            catch (Exception excInner) {
                LOG.error("Undo finally extract failed, mth: {}", (Object)mth, (Object)excInner);
            }
        }
    }

    private static boolean processExceptionHandler(MethodNode mth, ExceptionHandler excHandler) {
        boolean noExitNode = true;
        AttrNode reThrowInsn = null;
        for (BlockNode excBlock : excHandler.getBlocks()) {
            if (noExitNode) {
                noExitNode = excHandler.getBlocks().containsAll(excBlock.getCleanSuccessors());
            }
            List<InsnNode> insns = excBlock.getInstructions();
            int size = insns.size();
            if (!excHandler.isCatchAll() || size == 0 || insns.get(size - 1).getType() != InsnType.THROW) continue;
            reThrowInsn = insns.get(size - 1);
        }
        if (noExitNode && reThrowInsn != null) {
            boolean extracted = MarkFinallyVisitor.extractFinally(mth, excHandler);
            if (extracted) {
                reThrowInsn.add(AFlag.DONT_GENERATE);
            }
            return extracted;
        }
        return false;
    }

    private static boolean extractFinally(MethodNode mth, ExceptionHandler allHandler) {
        boolean bl;
        BlockNode block;
        InsnNode lastInsn;
        ArrayList<BlockNode> handlerBlocks = new ArrayList<BlockNode>();
        BlockNode handlerBlock = allHandler.getHandlerBlock();
        Iterator<BlockNode> iterator = BlockUtils.collectBlocksDominatedByWithExcHandlers(handlerBlock, handlerBlock).iterator();
        while (iterator.hasNext() && ((lastInsn = BlockUtils.getLastInsn(block = iterator.next())) == null || lastInsn.getType() != InsnType.THROW)) {
            handlerBlocks.add(block);
        }
        if (handlerBlocks.isEmpty() || BlockUtils.isAllBlocksEmpty(handlerBlocks)) {
            allHandler.getTryBlock().removeHandler(mth, allHandler);
            return true;
        }
        BlockNode startBlock = (BlockNode)handlerBlocks.get(0);
        FinallyExtractInfo extractInfo = new FinallyExtractInfo(allHandler, startBlock, handlerBlocks);
        TryCatchBlock tryBlock = allHandler.getTryBlock();
        if (tryBlock.getHandlersCount() > 1) {
            for (ExceptionHandler exceptionHandler : tryBlock.getHandlers()) {
                BlockNode checkBlock;
                if (exceptionHandler == allHandler) continue;
                Iterator<Object> iterator2 = exceptionHandler.getBlocks().iterator();
                while (iterator2.hasNext() && !MarkFinallyVisitor.searchDuplicateInsns(checkBlock = (BlockNode)iterator2.next(), extractInfo)) {
                    extractInfo.getFinallyInsnsSlice().resetIncomplete();
                }
            }
            if (extractInfo.getDuplicateSlices().size() != tryBlock.getHandlersCount() - 1) {
                return false;
            }
        }
        HashSet<BlockNode> splitters = new HashSet<BlockNode>();
        for (ExceptionHandler otherHandler : tryBlock.getHandlers()) {
            BlockNode splBlock;
            SplitterBlockAttr splitterAttr = otherHandler.getHandlerBlock().get(AType.SPLITTER_BLOCK);
            if (splitterAttr == null || (splBlock = splitterAttr.getBlock()).getCleanSuccessors().isEmpty()) continue;
            splitters.add(splBlock);
        }
        boolean bl2 = false;
        block4: for (BlockNode splitter : splitters) {
            BlockNode start = splitter.getCleanSuccessors().get(0);
            ArrayList<BlockNode> list = new ArrayList<BlockNode>();
            list.add(start);
            list.addAll(BlockUtils.collectBlocksDominatedByWithExcHandlers(start, start));
            LinkedHashSet checkSet = new LinkedHashSet(list);
            for (BlockNode block2 : checkSet) {
                if (MarkFinallyVisitor.searchDuplicateInsns(block2, extractInfo)) {
                    bl = true;
                    continue block4;
                }
                extractInfo.getFinallyInsnsSlice().resetIncomplete();
            }
        }
        if (!bl) {
            return false;
        }
        if (!MarkFinallyVisitor.checkSlices(extractInfo)) {
            mth.addComment("JADX INFO: finally extract failed");
            return false;
        }
        MarkFinallyVisitor.apply(extractInfo);
        allHandler.setFinally(true);
        return true;
    }

    private static boolean checkSlices(FinallyExtractInfo extractInfo) {
        InsnsSlice finallySlice = extractInfo.getFinallyInsnsSlice();
        List<InsnNode> finallyInsnsList = finallySlice.getInsnsList();
        for (InsnsSlice dupSlice : extractInfo.getDuplicateSlices()) {
            List<InsnNode> dupInsnsList = dupSlice.getInsnsList();
            if (dupInsnsList.size() == finallyInsnsList.size()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Incorrect finally slice size: {}, expected: {}", (Object)dupSlice, (Object)finallySlice);
            }
            return false;
        }
        for (int i = 0; i < finallyInsnsList.size(); ++i) {
            InsnNode finallyInsn = finallyInsnsList.get(i);
            for (InsnsSlice dupSlice : extractInfo.getDuplicateSlices()) {
                List<InsnNode> insnsList = dupSlice.getInsnsList();
                InsnNode dupInsn = insnsList.get(i);
                if (finallyInsn.getType() == dupInsn.getType()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Incorrect finally slice insn: {}, expected: {}", (Object)dupInsn, (Object)finallyInsn);
                }
                return false;
            }
        }
        return true;
    }

    private static void apply(FinallyExtractInfo extractInfo) {
        MarkFinallyVisitor.markSlice(extractInfo.getFinallyInsnsSlice(), AFlag.FINALLY_INSNS);
        for (InsnsSlice dupSlice : extractInfo.getDuplicateSlices()) {
            MarkFinallyVisitor.markSlice(dupSlice, AFlag.DONT_GENERATE);
        }
        InsnsSlice finallySlice = extractInfo.getFinallyInsnsSlice();
        List<InsnNode> finallyInsnsList = finallySlice.getInsnsList();
        for (int i = 0; i < finallyInsnsList.size(); ++i) {
            InsnNode finallyInsn = finallyInsnsList.get(i);
            for (InsnsSlice dupSlice : extractInfo.getDuplicateSlices()) {
                InsnNode dupInsn = dupSlice.getInsnsList().get(i);
                MarkFinallyVisitor.copyCodeVars(finallyInsn, dupInsn);
            }
        }
    }

    private static void markSlice(InsnsSlice slice, AFlag flag) {
        List<InsnNode> insnsList = slice.getInsnsList();
        for (InsnNode insn : insnsList) {
            insn.add(flag);
        }
        for (BlockNode block : slice.getBlocks()) {
            boolean allInsnMarked = true;
            for (InsnNode insn : block.getInstructions()) {
                if (insn.contains(flag)) continue;
                allInsnMarked = false;
                break;
            }
            if (!allInsnMarked) continue;
            block.add(flag);
        }
    }

    private static void copyCodeVars(InsnNode fromInsn, InsnNode toInsn) {
        MarkFinallyVisitor.copyCodeVars(fromInsn.getResult(), toInsn.getResult());
        int argsCount = fromInsn.getArgsCount();
        for (int i = 0; i < argsCount; ++i) {
            MarkFinallyVisitor.copyCodeVars(fromInsn.getArg(i), toInsn.getArg(i));
        }
    }

    private static void copyCodeVars(InsnArg fromArg, InsnArg toArg) {
        if (fromArg == null || toArg == null || !fromArg.isRegister() || !toArg.isRegister()) {
            return;
        }
        SSAVar fromSsaVar = ((RegisterArg)fromArg).getSVar();
        SSAVar toSsaVar = ((RegisterArg)toArg).getSVar();
        toSsaVar.setCodeVar(fromSsaVar.getCodeVar());
    }

    private static boolean searchDuplicateInsns(BlockNode checkBlock, FinallyExtractInfo extractInfo) {
        boolean isNew = extractInfo.getCheckedBlocks().add(checkBlock);
        if (!isNew) {
            return false;
        }
        BlockNode startBlock = extractInfo.getStartBlock();
        InsnsSlice dupSlice = MarkFinallyVisitor.searchFromFirstBlock(checkBlock, startBlock, extractInfo);
        if (dupSlice == null) {
            return false;
        }
        extractInfo.getDuplicateSlices().add(dupSlice);
        return true;
    }

    private static InsnsSlice searchFromFirstBlock(BlockNode dupBlock, BlockNode startBlock, FinallyExtractInfo extractInfo) {
        InsnsSlice dupSlice = MarkFinallyVisitor.isStartBlock(dupBlock, startBlock, extractInfo);
        if (dupSlice == null) {
            return null;
        }
        if (!dupSlice.isComplete() && !MarkFinallyVisitor.checkBlocksTree(dupBlock, startBlock, dupSlice, extractInfo)) {
            return null;
        }
        return MarkFinallyVisitor.checkTempSlice(dupSlice);
    }

    @Nullable
    private static InsnsSlice checkTempSlice(InsnsSlice slice) {
        InsnNode insnNode;
        List<InsnNode> insnsList = slice.getInsnsList();
        if (insnsList.isEmpty()) {
            return null;
        }
        if (insnsList.size() == 1 && (insnNode = insnsList.get(0)).getType() == InsnType.IF) {
            return null;
        }
        return slice;
    }

    private static InsnsSlice isStartBlock(BlockNode dupBlock, BlockNode finallyBlock, FinallyExtractInfo extractInfo) {
        boolean complete;
        int endIndex;
        List<InsnNode> dupInsns = dupBlock.getInstructions();
        List<InsnNode> finallyInsns = finallyBlock.getInstructions();
        if (dupInsns.size() < finallyInsns.size()) {
            return null;
        }
        int startPos = dupInsns.size() - finallyInsns.size();
        int endPos = 0;
        if (!MarkFinallyVisitor.checkInsns(dupInsns, finallyInsns, startPos)) {
            if (MarkFinallyVisitor.checkInsns(dupInsns, finallyInsns, 0)) {
                startPos = 0;
                endPos = finallyInsns.size();
            } else {
                boolean found = false;
                for (int i = 1; i < startPos; ++i) {
                    if (!MarkFinallyVisitor.checkInsns(dupInsns, finallyInsns, i)) continue;
                    startPos = i;
                    endPos = finallyInsns.size() + i;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
            }
        }
        InsnsSlice slice = new InsnsSlice();
        if (endPos != 0) {
            endIndex = endPos + 1;
            complete = true;
        } else {
            endIndex = dupInsns.size();
            complete = false;
        }
        for (int i = startPos; i < endIndex; ++i) {
            slice.addInsn(dupInsns.get(i), dupBlock);
        }
        InsnsSlice finallySlice = extractInfo.getFinallyInsnsSlice();
        if (finallySlice.isComplete()) {
            if (finallySlice.getInsnsList().size() != slice.getInsnsList().size()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Another duplicated slice has different insns count: {}, finally: {}", (Object)slice, (Object)finallySlice);
                }
                return null;
            }
        } else {
            for (InsnNode finallyInsn : finallyInsns) {
                finallySlice.addInsn(finallyInsn, finallyBlock);
            }
        }
        if (complete) {
            slice.setComplete(true);
            finallySlice.setComplete(true);
        }
        return slice;
    }

    private static boolean checkInsns(List<InsnNode> remInsns, List<InsnNode> finallyInsns, int delta) {
        for (int i = finallyInsns.size() - 1; i >= 0; --i) {
            InsnNode startInsn = finallyInsns.get(i);
            InsnNode remInsn = remInsns.get(delta + i);
            if (MarkFinallyVisitor.sameInsns(remInsn, startInsn)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBlocksTree(BlockNode dupBlock, BlockNode finallyBlock, InsnsSlice dupSlice, FinallyExtractInfo extractInfo) {
        InsnsSlice finallySlice = extractInfo.getFinallyInsnsSlice();
        List<BlockNode> finallyCS = finallyBlock.getSuccessors();
        List<BlockNode> dupCS = dupBlock.getSuccessors();
        if (finallyCS.size() == dupCS.size()) {
            for (int i = 0; i < finallyCS.size(); ++i) {
                BlockNode finSBlock = finallyCS.get(i);
                BlockNode dupSBlock = dupCS.get(i);
                if (!extractInfo.getAllHandlerBlocks().contains(finSBlock)) continue;
                if (!MarkFinallyVisitor.compareBlocks(dupSBlock, finSBlock, dupSlice, extractInfo)) {
                    return false;
                }
                if (!MarkFinallyVisitor.checkBlocksTree(dupSBlock, finSBlock, dupSlice, extractInfo)) {
                    return false;
                }
                dupSlice.addBlock(dupSBlock);
                finallySlice.addBlock(finSBlock);
            }
        }
        dupSlice.setComplete(true);
        finallySlice.setComplete(true);
        return true;
    }

    private static boolean compareBlocks(BlockNode dupBlock, BlockNode finallyBlock, InsnsSlice dupSlice, FinallyExtractInfo extractInfo) {
        List<InsnNode> dupInsns = dupBlock.getInstructions();
        List<InsnNode> finallyInsns = finallyBlock.getInstructions();
        int dupInsnCount = dupInsns.size();
        int finallyInsnCount = finallyInsns.size();
        if (finallyInsnCount == 0) {
            return dupInsnCount == 0;
        }
        if (dupInsnCount < finallyInsnCount) {
            return false;
        }
        for (int i = 0; i < finallyInsnCount; ++i) {
            if (MarkFinallyVisitor.sameInsns(dupInsns.get(i), finallyInsns.get(i))) continue;
            return false;
        }
        if (dupInsnCount > finallyInsnCount) {
            dupSlice.addInsns(dupBlock, 0, finallyInsnCount);
            dupSlice.setComplete(true);
            InsnsSlice finallyInsnsSlice = extractInfo.getFinallyInsnsSlice();
            finallyInsnsSlice.addBlock(finallyBlock);
            finallyInsnsSlice.setComplete(true);
        }
        return true;
    }

    private static boolean sameInsns(InsnNode remInsn, InsnNode fInsn) {
        if (!remInsn.isSame(fInsn)) {
            return false;
        }
        for (int i = 0; i < remInsn.getArgsCount(); ++i) {
            InsnArg remArg = remInsn.getArg(i);
            InsnArg fArg = fInsn.getArg(i);
            if (remArg.isRegister() == fArg.isRegister()) continue;
            return false;
        }
        return true;
    }
}

