/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.shrink;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.visitors.shrink.WrapInfo;
import jadx.core.utils.EmptyBitSet;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;

final class ArgsInfo {
    private final InsnNode insn;
    private final List<ArgsInfo> argsList;
    private final List<RegisterArg> args;
    private final int pos;
    private int inlineBorder;
    private ArgsInfo inlinedInsn;

    public ArgsInfo(InsnNode insn, List<ArgsInfo> argsList, int pos) {
        this.insn = insn;
        this.argsList = argsList;
        this.pos = pos;
        this.inlineBorder = pos;
        this.args = ArgsInfo.getArgs(insn);
    }

    public static List<RegisterArg> getArgs(InsnNode insn) {
        LinkedList<RegisterArg> args = new LinkedList<RegisterArg>();
        ArgsInfo.addArgs(insn, args);
        return args;
    }

    private static void addArgs(InsnNode insn, List<RegisterArg> args) {
        if (insn.getType() == InsnType.TERNARY) {
            args.addAll(((TernaryInsn)insn).getCondition().getRegisterArgs());
        }
        for (InsnArg arg : insn.getArguments()) {
            if (!arg.isRegister()) continue;
            args.add((RegisterArg)arg);
        }
        for (InsnArg arg : insn.getArguments()) {
            if (!arg.isInsnWrap()) continue;
            ArgsInfo.addArgs(((InsnWrapArg)arg).getWrapInsn(), args);
        }
    }

    public InsnNode getInsn() {
        return this.insn;
    }

    List<RegisterArg> getArgs() {
        return this.args;
    }

    public WrapInfo checkInline(int assignPos, RegisterArg arg) {
        if (assignPos >= this.inlineBorder || !this.canMove(assignPos, this.inlineBorder)) {
            return null;
        }
        this.inlineBorder = assignPos;
        return this.inline(assignPos, arg);
    }

    private boolean canMove(int from, int to) {
        BitSet movedSet;
        ArgsInfo startInfo = this.argsList.get(from);
        List<RegisterArg> movedArgs = startInfo.getArgs();
        int start = from + 1;
        if (start == to) {
            return true;
        }
        if (start > to) {
            throw new JadxRuntimeException("Invalid inline insn positions: " + start + " - " + to);
        }
        if (movedArgs.isEmpty()) {
            if (startInfo.insn.isConstInsn()) {
                return true;
            }
            movedSet = EmptyBitSet.EMPTY;
        } else {
            movedSet = new BitSet();
            for (RegisterArg arg : movedArgs) {
                movedSet.set(arg.getRegNum());
            }
        }
        boolean canReorder = startInfo.insn.canReorder();
        for (int i = start; i < to; ++i) {
            ArgsInfo argsInfo = this.argsList.get(i);
            if (argsInfo.getInlinedInsn() == this) continue;
            InsnNode curInsn = argsInfo.insn;
            if (!(canReorder ? ArgsInfo.usedArgAssign(curInsn, movedSet) : !curInsn.canReorder() || ArgsInfo.usedArgAssign(curInsn, movedSet))) continue;
            return false;
        }
        return true;
    }

    static boolean usedArgAssign(InsnNode insn, BitSet args) {
        if (args.isEmpty()) {
            return false;
        }
        RegisterArg result = insn.getResult();
        if (result == null) {
            return false;
        }
        return args.get(result.getRegNum());
    }

    WrapInfo inline(int assignInsnPos, RegisterArg arg) {
        ArgsInfo argsInfo = this.argsList.get(assignInsnPos);
        argsInfo.inlinedInsn = this;
        return new WrapInfo(argsInfo.insn, arg);
    }

    ArgsInfo getInlinedInsn() {
        ArgsInfo parent;
        if (this.inlinedInsn != null && (parent = this.inlinedInsn.getInlinedInsn()) != null) {
            this.inlinedInsn = parent;
        }
        return this.inlinedInsn;
    }

    public String toString() {
        return "ArgsInfo: |" + this.inlineBorder + " ->" + (this.inlinedInsn == null ? "-" : Integer.valueOf(this.inlinedInsn.pos)) + ' ' + this.args + " : " + this.insn;
    }
}

