/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.typeinference.TypeUpdateEntry;
import jadx.core.dex.visitors.typeinference.TypeUpdateFlags;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.ArrayList;
import java.util.List;

public class TypeUpdateInfo {
    private final MethodNode mth;
    private final TypeUpdateFlags flags;
    private final List<TypeUpdateEntry> updates = new ArrayList<TypeUpdateEntry>();
    private final int updatesLimitCount;

    public TypeUpdateInfo(MethodNode mth, TypeUpdateFlags flags) {
        this.mth = mth;
        this.flags = flags;
        this.updatesLimitCount = mth.getInsnsCount() * 5;
    }

    public void requestUpdate(InsnArg arg, ArgType changeType) {
        this.updates.add(new TypeUpdateEntry(arg, changeType));
    }

    public void applyUpdates() {
        for (TypeUpdateEntry updateEntry : this.updates) {
            InsnArg arg = updateEntry.getArg();
            arg.setType(updateEntry.getType());
        }
    }

    public boolean isProcessed(InsnArg arg) {
        if (this.updates.isEmpty()) {
            return false;
        }
        for (TypeUpdateEntry entry : this.updates) {
            if (entry.getArg() != arg) continue;
            return true;
        }
        return false;
    }

    public ArgType getType(InsnArg arg) {
        for (TypeUpdateEntry update : this.updates) {
            if (update.getArg() != arg) continue;
            return update.getType();
        }
        return arg.getType();
    }

    public void rollbackUpdate(InsnArg arg) {
        this.updates.removeIf(updateEntry -> updateEntry.getArg() == arg);
    }

    public void checkUpdatesCount() {
        if (this.updates.size() > this.updatesLimitCount) {
            throw new JadxOverflowException("Type inference error: update tree size limit reached");
        }
    }

    public MethodNode getMth() {
        return this.mth;
    }

    public List<TypeUpdateEntry> getUpdates() {
        return this.updates;
    }

    public TypeUpdateFlags getFlags() {
        return this.flags;
    }

    public String toString() {
        return "TypeUpdateInfo{" + this.flags + ", updates=" + this.updates + '}';
    }
}

