/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.android;

import jadx.core.utils.android.ExtDataInput;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class Res9patchStreamDecoder {
    private static final int NP_CHUNK_TYPE = 1852855395;
    private static final int NP_COLOR = -16777216;

    public void decode(InputStream in, OutputStream out) {
        try {
            BufferedImage im = ImageIO.read(in);
            int w = im.getWidth();
            int h = im.getHeight();
            BufferedImage im2 = new BufferedImage(w + 2, h + 2, 2);
            im2.createGraphics().drawImage(im, 1, 1, w, h, null);
            NinePatch np = this.getNinePatch(in);
            this.drawHLine(im2, h + 1, np.padLeft + 1, w - np.padRight);
            this.drawVLine(im2, w + 1, np.padTop + 1, h - np.padBottom);
            int[] xDivs = np.xDivs;
            for (int i = 0; i < xDivs.length - 1; i += 2) {
                this.drawHLine(im2, 0, xDivs[i] + 1, xDivs[i + 1]);
            }
            int[] yDivs = np.yDivs;
            for (int i = 0; i < yDivs.length - 1; i += 2) {
                this.drawVLine(im2, 0, yDivs[i] + 1, yDivs[i + 1]);
            }
            ImageIO.write((RenderedImage)im2, "png", out);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("9patch image decode error", e);
        }
    }

    private NinePatch getNinePatch(InputStream in) throws IOException {
        ExtDataInput di = new ExtDataInput(in);
        this.find9patchChunk(di);
        return NinePatch.decode(di);
    }

    private void find9patchChunk(DataInput di) throws IOException {
        di.skipBytes(8);
        while (true) {
            int size;
            try {
                size = di.readInt();
            }
            catch (IOException ex) {
                throw new JadxRuntimeException("Cant find nine patch chunk", ex);
            }
            if (di.readInt() == 1852855395) {
                return;
            }
            di.skipBytes(size + 4);
        }
    }

    private void drawHLine(BufferedImage im, int y, int x1, int x2) {
        for (int x = x1; x <= x2; ++x) {
            im.setRGB(x, y, -16777216);
        }
    }

    private void drawVLine(BufferedImage im, int x, int y1, int y2) {
        for (int y = y1; y <= y2; ++y) {
            im.setRGB(x, y, -16777216);
        }
    }

    private static class NinePatch {
        public final int padLeft;
        public final int padRight;
        public final int padTop;
        public final int padBottom;
        public final int[] xDivs;
        public final int[] yDivs;

        public NinePatch(int padLeft, int padRight, int padTop, int padBottom, int[] xDivs, int[] yDivs) {
            this.padLeft = padLeft;
            this.padRight = padRight;
            this.padTop = padTop;
            this.padBottom = padBottom;
            this.xDivs = xDivs;
            this.yDivs = yDivs;
        }

        public static NinePatch decode(ExtDataInput di) throws IOException {
            di.skipBytes(1);
            byte numXDivs = di.readByte();
            byte numYDivs = di.readByte();
            di.skipBytes(1);
            di.skipBytes(8);
            int padLeft = di.readInt();
            int padRight = di.readInt();
            int padTop = di.readInt();
            int padBottom = di.readInt();
            di.skipBytes(4);
            int[] xDivs = di.readIntArray(numXDivs);
            int[] yDivs = di.readIntArray(numYDivs);
            return new NinePatch(padLeft, padRight, padTop, padBottom, xDivs, yDivs);
        }
    }
}

