/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.xmleditor;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.StyleContext;

public class XMLContext
extends StyleContext {
    public static final String XML_DECLARATION_STYLE = "xml_declaration";
    public static final String DOCTYPE_STYLE = "doctype";
    public static final String COMMENT_STYLE = "comment";
    public static final String ELEMENT_STYLE = "element";
    public static final String CHARACTER_DATA_STYLE = "character_data";
    public static final String ATTRIBUTE_NAME_STYLE = "attribute_name";
    public static final String ATTRIBUTE_VALUE_STYLE = "attribute_value";
    public static final String CDATA_STYLE = "cdata";
    protected Map syntaxForegroundMap = null;
    protected Map syntaxFontMap = null;

    public XMLContext() {
        this.syntaxFontMap = new HashMap();
        this.syntaxForegroundMap = new HashMap();
        Font font = new Font("Monospaced", 0, 12);
        String string = "default";
        Font font2 = font;
        Color color = Color.black;
        this.syntaxFontMap.put(string, font2);
        this.syntaxForegroundMap.put(string, color);
        string = XML_DECLARATION_STYLE;
        font2 = font.deriveFont(1);
        color = new Color(0, 0, 124);
        this.syntaxFontMap.put(string, font2);
        this.syntaxForegroundMap.put(string, color);
        string = DOCTYPE_STYLE;
        font2 = font.deriveFont(1);
        color = new Color(0, 0, 124);
        this.syntaxFontMap.put(string, font2);
        this.syntaxForegroundMap.put(string, color);
        string = COMMENT_STYLE;
        font2 = font;
        color = new Color(128, 128, 128);
        this.syntaxFontMap.put(string, font2);
        this.syntaxForegroundMap.put(string, color);
        string = ELEMENT_STYLE;
        font2 = font;
        color = new Color(0, 0, 255);
        this.syntaxFontMap.put(string, font2);
        this.syntaxForegroundMap.put(string, color);
        string = CHARACTER_DATA_STYLE;
        font2 = font;
        color = Color.black;
        this.syntaxFontMap.put(string, font2);
        this.syntaxForegroundMap.put(string, color);
        string = ATTRIBUTE_NAME_STYLE;
        font2 = font;
        color = new Color(0, 124, 0);
        this.syntaxFontMap.put(string, font2);
        this.syntaxForegroundMap.put(string, color);
        string = ATTRIBUTE_VALUE_STYLE;
        font2 = font;
        color = new Color(153, 0, 107);
        this.syntaxFontMap.put(string, font2);
        this.syntaxForegroundMap.put(string, color);
        string = CDATA_STYLE;
        font2 = font;
        color = new Color(124, 98, 0);
        this.syntaxFontMap.put(string, font2);
        this.syntaxForegroundMap.put(string, color);
    }

    public XMLContext(Map map, Map map2) {
        this.setSyntaxFont(map);
        this.setSyntaxForeground(map2);
    }

    public void setSyntaxForeground(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("syntaxForegroundMap can not be null");
        }
        this.syntaxForegroundMap = map;
    }

    public void setSyntaxFont(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("syntaxFontMap can not be null");
        }
        this.syntaxFontMap = map;
    }

    public Color getSyntaxForeground(int n) {
        String string = this.getSyntaxName(n);
        return this.getSyntaxForeground(string);
    }

    public Color getSyntaxForeground(String string) {
        return (Color)this.syntaxForegroundMap.get(string);
    }

    public Font getSyntaxFont(int n) {
        String string = this.getSyntaxName(n);
        return this.getSyntaxFont(string);
    }

    public Font getSyntaxFont(String string) {
        return (Font)this.syntaxFontMap.get(string);
    }

    public String getSyntaxName(int n) {
        String string = CHARACTER_DATA_STYLE;
        switch (n) {
            case 6: {
                string = XML_DECLARATION_STYLE;
                break;
            }
            case 7: {
                string = DOCTYPE_STYLE;
                break;
            }
            case 1: {
                string = COMMENT_STYLE;
                break;
            }
            case 2: {
                string = ELEMENT_STYLE;
                break;
            }
            case 4: {
                string = ATTRIBUTE_NAME_STYLE;
                break;
            }
            case 5: {
                string = ATTRIBUTE_VALUE_STYLE;
                break;
            }
            case 10: {
                string = CDATA_STYLE;
                break;
            }
            default: {
                string = "default";
            }
        }
        return string;
    }
}

