/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class CreateValuePartition
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public CreateValuePartition(@Nonnull OWLDataFactory dataFactory, @Nonnull OWLClass valuePartitionClass, @Nonnull Set<OWLClass> valuePartionClasses, @Nonnull OWLObjectProperty valuePartitionProperty, @Nonnull OWLOntology targetOntology) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(targetOntology, "targetOntology cannot be null"), OWLAPIPreconditions.checkNotNull(valuePartionClasses, "valuePartionClasses cannot be null"), OWLAPIPreconditions.checkNotNull(valuePartitionClass, "valuePartitionClass cannot be null"), OWLAPIPreconditions.checkNotNull(valuePartitionProperty, "valuePartitionProperty cannot be null"));
    }

    private void generateChanges(@Nonnull OWLOntology targetOntology, @Nonnull Set<OWLClass> valuePartitionClasses, @Nonnull OWLClass valuePartitionClass, @Nonnull OWLObjectProperty valuePartitionProperty) {
        for (OWLClassExpression oWLClassExpression : valuePartitionClasses) {
            assert (oWLClassExpression != null);
            this.addChange(new AddAxiom(targetOntology, this.getDataFactory().getOWLSubClassOfAxiom(oWLClassExpression, valuePartitionClass)));
        }
        this.addChange(new AddAxiom(targetOntology, this.getDataFactory().getOWLDisjointClassesAxiom(valuePartitionClasses)));
        OWLObjectUnionOf union = this.getDataFactory().getOWLObjectUnionOf(valuePartitionClasses);
        this.addChange(new AddAxiom(targetOntology, this.getDataFactory().getOWLSubClassOfAxiom(valuePartitionClass, union)));
        this.addChange(new AddAxiom(targetOntology, this.getDataFactory().getOWLFunctionalObjectPropertyAxiom(valuePartitionProperty)));
        this.addChange(new AddAxiom(targetOntology, this.getDataFactory().getOWLObjectPropertyRangeAxiom(valuePartitionProperty, valuePartitionClass)));
    }
}

