/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;
import org.xml.sax.InputSource;

public abstract class AbstractOWLParser
implements OWLParser,
Serializable {
    private static final long serialVersionUID = 40000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOWLParser.class);
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final Pattern CONTENT_DISPOSITION_FILE_NAME_PATTERN = Pattern.compile(".*filename=\"([^\\s;]*)\".*");
    private static final int CONTENT_DISPOSITION_FILE_NAME_PATTERN_GROUP = 1;
    private static final Pattern ZIP_ENTRY_ONTOLOGY_NAME_PATTERN = Pattern.compile(".*owl|rdf|xml|mos");
    private final String acceptableContentEncoding = "xz,gzip,deflate";
    private static final String TEXTPLAIN_REQUEST_TYPE = ", text/plain; q=0.1";
    private static final String LAST_REQUEST_TYPE = ", */*; q=0.09";
    protected static final String DEFAULT_REQUEST = "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09";

    protected AbstractOWLParser() {
    }

    @Nonnull
    protected InputStream getInputStream(@Nonnull IRI documentIRI, @Nonnull OWLOntologyLoaderConfiguration config, String acceptHeaders) throws IOException {
        String actualAcceptHeaders = acceptHeaders;
        if (!acceptHeaders.contains("text/plain")) {
            actualAcceptHeaders = actualAcceptHeaders + TEXTPLAIN_REQUEST_TYPE;
        }
        if (!acceptHeaders.contains("*/*")) {
            actualAcceptHeaders = actualAcceptHeaders + LAST_REQUEST_TYPE;
        }
        URL originalURL = documentIRI.toURI().toURL();
        String originalProtocol = originalURL.getProtocol();
        URLConnection conn = originalURL.openConnection();
        conn.addRequestProperty("Accept", actualAcceptHeaders);
        if (config.getAuthorizationValue() != null && !config.getAuthorizationValue().isEmpty()) {
            conn.setRequestProperty("Authorization", config.getAuthorizationValue());
        }
        if (config.isAcceptingHTTPCompression()) {
            conn.setRequestProperty("Accept-Encoding", "xz,gzip,deflate");
        }
        int connectionTimeout = config.getConnectionTimeout();
        conn.setConnectTimeout(connectionTimeout);
        if (conn instanceof HttpURLConnection && config.isFollowRedirects()) {
            String location;
            URL newURL;
            String newProtocol;
            HttpURLConnection con = (HttpURLConnection)conn;
            con.connect();
            int responseCode = con.getResponseCode();
            if (!(responseCode != 302 && responseCode != 301 && responseCode != 303 || originalProtocol.equals(newProtocol = (newURL = new URL(location = con.getHeaderField("Location"))).getProtocol()))) {
                conn = newURL.openConnection();
                conn.addRequestProperty("Accept", actualAcceptHeaders);
                if (config.getAuthorizationValue() != null && !config.getAuthorizationValue().isEmpty()) {
                    conn.setRequestProperty("Authorization", config.getAuthorizationValue());
                }
                if (config.isAcceptingHTTPCompression()) {
                    conn.setRequestProperty("Accept-Encoding", "xz,gzip,deflate");
                }
                conn.setConnectTimeout(connectionTimeout);
            }
        }
        String contentEncoding = conn.getContentEncoding();
        InputStream is = null;
        int count = 0;
        while (count < config.getRetriesToAttempt() && is == null) {
            try {
                is = AbstractOWLParser.getInputStreamFromContentEncoding(conn, contentEncoding);
            }
            catch (SocketTimeoutException e) {
                if (++count == 5) {
                    throw e;
                }
                conn.setConnectTimeout(connectionTimeout + connectionTimeout * count);
            }
        }
        if (is == null) {
            throw new IOException("cannot connect to " + documentIRI + "; retry limit exhausted");
        }
        if (AbstractOWLParser.isZipName(documentIRI, conn)) {
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry entry = null;
            ZipEntry nextEntry = zis.getNextEntry();
            while (entry != null && nextEntry != null) {
                if (AbstractOWLParser.couldBeOntology(nextEntry)) {
                    entry = nextEntry;
                }
                nextEntry = zis.getNextEntry();
            }
            is = zis;
        }
        return is;
    }

    private static boolean couldBeOntology(@Nullable ZipEntry zipEntry) {
        if (zipEntry == null) {
            return false;
        }
        return ZIP_ENTRY_ONTOLOGY_NAME_PATTERN.matcher(zipEntry.getName()).matches();
    }

    @Nonnull
    private static InputStream getInputStreamFromContentEncoding(@Nonnull URLConnection conn, @Nullable String contentEncoding) throws IOException {
        InputStream is = null;
        InputStream connInputStream = conn.getInputStream();
        if (contentEncoding != null) {
            if ("xz".equals(contentEncoding)) {
                LOGGER.info("URL connection input stream is compressed using xz");
                is = new BufferedInputStream((InputStream)new XZInputStream(connInputStream));
            } else if ("gzip".equals(contentEncoding)) {
                LOGGER.info("URL connection input stream is compressed using gzip");
                is = new BufferedInputStream(new GZIPInputStream(connInputStream));
            } else if ("deflate".equals(contentEncoding)) {
                LOGGER.info("URL connection input stream is compressed using deflate");
                is = OWLOntologyDocumentSourceBase.wrap(new InflaterInputStream(connInputStream, new Inflater(true)));
            }
        } else {
            String fileName = AbstractOWLParser.getFileNameFromContentDisposition(conn);
            if (fileName == null && conn.getURL() != null) {
                fileName = conn.getURL().toString();
            }
            if (fileName != null) {
                if (fileName.endsWith(".gz")) {
                    LOGGER.info("URL connection has no content encoding but name ends with .gz");
                    is = new BufferedInputStream(new GZIPInputStream(connInputStream));
                } else if (fileName.endsWith(".xz")) {
                    LOGGER.info("URL connection has no content encoding but name ends with .xz");
                    is = new BufferedInputStream((InputStream)new XZInputStream(connInputStream));
                }
            }
        }
        if (is == null) {
            is = OWLOntologyDocumentSourceBase.wrap(connInputStream);
        }
        return is;
    }

    private static boolean isZipName(@Nonnull IRI documentIRI, @Nonnull URLConnection connection) {
        if (AbstractOWLParser.isZipFileName(documentIRI.toString())) {
            return true;
        }
        String fileName = AbstractOWLParser.getFileNameFromContentDisposition(connection);
        return fileName != null && AbstractOWLParser.isZipFileName(fileName);
    }

    @Nullable
    private static String getFileNameFromContentDisposition(@Nonnull URLConnection connection) {
        Matcher matcher;
        String contentDispositionHeaderValue = connection.getHeaderField(CONTENT_DISPOSITION_HEADER);
        if (contentDispositionHeaderValue != null && (matcher = CONTENT_DISPOSITION_FILE_NAME_PATTERN.matcher(contentDispositionHeaderValue)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean isZipFileName(@Nonnull String fileName) {
        return fileName.toLowerCase(Locale.getDefault()).endsWith(ZIP_FILE_EXTENSION);
    }

    @Nonnull
    protected InputSource getInputSource(@Nonnull OWLOntologyDocumentSource documentSource, @Nonnull OWLOntologyLoaderConfiguration config) throws IOException {
        InputSource is;
        if (documentSource.isReaderAvailable()) {
            is = new InputSource(documentSource.getReader());
        } else if (documentSource.isInputStreamAvailable()) {
            is = new InputSource(documentSource.getInputStream());
        } else {
            if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:")) {
                try {
                    return new InputSource(((JarURLConnection)new URL(documentSource.getDocumentIRI().toString()).openConnection()).getInputStream());
                }
                catch (IOException e) {
                    throw new OWLParserException(e);
                }
            }
            Optional<String> headers = documentSource.getAcceptHeaders();
            is = headers.isPresent() ? new InputSource(this.getInputStream(documentSource.getDocumentIRI(), config, headers.get())) : new InputSource(this.getInputStream(documentSource.getDocumentIRI(), config, DEFAULT_REQUEST));
        }
        is.setSystemId(documentSource.getDocumentIRI().toString());
        return is;
    }

    @Override
    @Nonnull
    public OWLDocumentFormat parse(IRI documentIRI, OWLOntology ontology) throws IOException {
        return this.parse(new IRIDocumentSource(documentIRI, null, null), ontology, ontology.getOWLOntologyManager().getOntologyLoaderConfiguration());
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

