/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLEntityURIConverterStrategy;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class OWLEntityURIConverter {
    @Nonnull
    private final OWLOntologyManager manager;
    @Nonnull
    private final Collection<OWLOntology> ontologies;
    @Nonnull
    private final Map<OWLEntity, IRI> replacementMap = new HashMap<OWLEntity, IRI>();
    private Set<OWLEntity> processedEntities;
    @Nonnull
    private final OWLEntityURIConverterStrategy strategy;

    public OWLEntityURIConverter(@Nonnull OWLOntologyManager manager, @Nonnull Set<OWLOntology> ontologies, @Nonnull OWLEntityURIConverterStrategy strategy) {
        this.manager = OWLAPIPreconditions.checkNotNull(manager, "manager cannot be null");
        this.ontologies = new ArrayList<OWLOntology>((Collection)OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"));
        this.strategy = OWLAPIPreconditions.checkNotNull(strategy, "strategy cannot be null");
    }

    public List<OWLOntologyChange> getChanges() {
        this.replacementMap.clear();
        this.processedEntities = new HashSet<OWLEntity>();
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLClass oWLClass : ont.getClassesInSignature()) {
                if (oWLClass.isOWLThing() || oWLClass.isOWLNothing()) continue;
                this.processEntity(oWLClass);
            }
            for (OWLObjectProperty oWLObjectProperty : ont.getObjectPropertiesInSignature()) {
                assert (oWLObjectProperty != null);
                this.processEntity(oWLObjectProperty);
            }
            for (OWLDataProperty oWLDataProperty : ont.getDataPropertiesInSignature()) {
                assert (oWLDataProperty != null);
                this.processEntity(oWLDataProperty);
            }
            for (OWLNamedIndividual oWLNamedIndividual : ont.getIndividualsInSignature()) {
                assert (oWLNamedIndividual != null);
                this.processEntity(oWLNamedIndividual);
            }
        }
        OWLObjectDuplicator dup = new OWLObjectDuplicator(this.replacementMap, this.manager.getOWLDataFactory());
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            for (OWLAxiom ax : ont.getAxioms()) {
                assert (ax != null);
                OWLAxiom dupAx = (OWLAxiom)dup.duplicateObject(ax);
                if (dupAx.equals(ax)) continue;
                changes.add(new RemoveAxiom(ont, ax));
                changes.add(new AddAxiom(ont, dupAx));
            }
        }
        return changes;
    }

    private void processEntity(@Nonnull OWLEntity ent) {
        if (this.processedEntities.contains(ent)) {
            return;
        }
        IRI rep = this.getTinyIRI(ent);
        this.replacementMap.put(ent, rep);
        this.processedEntities.add(ent);
    }

    private IRI getTinyIRI(@Nonnull OWLEntity ent) {
        return this.strategy.getConvertedIRI(ent);
    }
}

