/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.AbstractEntityRegistrationManager;

public class OWLEntityCollectionContainerCollector
extends AbstractEntityRegistrationManager {
    private Collection<OWLEntity> objects;
    @Nullable
    private final Collection<OWLAnonymousIndividual> anonymousIndividuals;
    private boolean collectClasses = true;
    private boolean collectObjectProperties = true;
    private boolean collectDataProperties = true;
    private boolean collectIndividuals = true;
    private boolean collectDatatypes = true;

    public OWLEntityCollectionContainerCollector(Set<OWLEntity> toReturn, Collection<OWLAnonymousIndividual> anonsToReturn) {
        this.objects = toReturn;
        this.anonymousIndividuals = anonsToReturn;
    }

    public OWLEntityCollectionContainerCollector(Set<OWLEntity> toReturn) {
        this.objects = toReturn;
        this.anonymousIndividuals = null;
    }

    public void reset(Set<OWLEntity> toReturn) {
        this.objects = toReturn;
        if (this.anonymousIndividuals != null) {
            OWLAPIPreconditions.verifyNotNull(this.anonymousIndividuals).clear();
        }
    }

    public void setCollectClasses(boolean collectClasses) {
        this.collectClasses = collectClasses;
    }

    public void setCollectObjectProperties(boolean collectObjectProperties) {
        this.collectObjectProperties = collectObjectProperties;
    }

    public void setCollectDataProperties(boolean collectDataProperties) {
        this.collectDataProperties = collectDataProperties;
    }

    public void setCollectIndividuals(boolean collectIndividuals) {
        this.collectIndividuals = collectIndividuals;
    }

    public void setCollectDatatypes(boolean collectDatatypes) {
        this.collectDatatypes = collectDatatypes;
    }

    @Override
    public void visit(OWLClass ce) {
        if (this.collectClasses) {
            this.objects.add(ce);
        }
    }

    @Override
    public void visit(OWLObjectProperty property) {
        if (this.collectObjectProperties) {
            this.objects.add(property);
        }
    }

    @Override
    public void visit(OWLDataProperty property) {
        if (this.collectDataProperties) {
            this.objects.add(property);
        }
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        if (this.collectIndividuals) {
            this.objects.add(individual);
        }
    }

    @Override
    public void visit(OWLDatatype node) {
        if (this.collectDatatypes) {
            this.objects.add(node);
        }
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        if (this.anonymousIndividuals != null) {
            OWLAPIPreconditions.verifyNotNull(this.anonymousIndividuals).add(individual);
        }
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.objects.addAll(ontology.getSignature());
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.objects.add(property);
    }
}

