/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.axiom;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.model.HasActiveOntology;
import org.protege.editor.owl.model.axiom.AxiomSubjectProvider;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationStrategy;
import org.protege.editor.owl.model.axiom.SubjectDefinitionExtractor;
import org.protege.editor.owl.model.axiom.TopologicallySortedImportsClosureProvider;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class SubjectDefinitionLocationStrategy
implements FreshAxiomLocationStrategy {
    private TopologicallySortedImportsClosureProvider importsClosureProvider;
    private SubjectDefinitionExtractor subjectDefinitionExtractor;
    private AxiomSubjectProvider axiomSubjectProvider;

    public SubjectDefinitionLocationStrategy(TopologicallySortedImportsClosureProvider importsClosureProvider, AxiomSubjectProvider axiomSubjectProvider, SubjectDefinitionExtractor subjectDefinitionExtractor) {
        this.importsClosureProvider = importsClosureProvider;
        this.axiomSubjectProvider = axiomSubjectProvider;
        this.subjectDefinitionExtractor = subjectDefinitionExtractor;
    }

    @Override
    public OWLOntology getFreshAxiomLocation(OWLAxiom axiom, HasActiveOntology hasActiveOntology) {
        Optional<OWLObject> subject = this.axiomSubjectProvider.getAxiomSubject(axiom);
        if (!subject.isPresent()) {
            return this.getDefaultLocation(hasActiveOntology);
        }
        return this.getDefiningImportsClosureRootOntology(hasActiveOntology, (OWLObject)subject.get());
    }

    private OWLOntology getDefiningImportsClosureRootOntology(HasActiveOntology hasActiveOntology, OWLObject subject) {
        OWLOntology activeOntology = hasActiveOntology.getActiveOntology();
        List<OWLOntology> sortedImportsClosure = this.importsClosureProvider.getTopologicallySortedImportsClosure(activeOntology);
        for (OWLOntology ont : sortedImportsClosure) {
            Set<OWLAxiom> definingAxioms = this.subjectDefinitionExtractor.getDefiningAxioms(subject, ont);
            if (definingAxioms.isEmpty()) continue;
            return ont;
        }
        return this.getDefaultLocation(hasActiveOntology);
    }

    private OWLOntology getDefaultLocation(HasActiveOntology hasActiveOntology) {
        return hasActiveOntology.getActiveOntology();
    }
}

