/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import org.protege.editor.owl.ui.renderer.EntityActionIcon;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;

public class AddEntityIcon
implements Icon {
    private final OWLEntityIcon entityIcon;

    public AddEntityIcon(OWLEntityIcon entityIcon) {
        this.entityIcon = entityIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            EntityActionIcon.setupAlpha(c, g2);
            this.entityIcon.paintIcon(c, g2, x + 1, y + 1);
            int addCrossLegLength = 2;
            int xC = x + this.entityIcon.getIconWidth() + addCrossLegLength;
            int yC = y + 4;
            g2.setStroke(EntityActionIcon.ACTION_STROKE);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setColor(this.entityIcon.getEntityColor());
            g2.drawLine(xC - addCrossLegLength, yC, xC + addCrossLegLength, yC);
            g2.drawLine(xC, yC - addCrossLegLength, xC, yC + addCrossLegLength);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        return this.entityIcon.getIconWidth() + 2;
    }

    @Override
    public int getIconHeight() {
        return this.entityIcon.getIconHeight() + 2;
    }
}

