/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class LookUtils
extends SystemUtils {
    public static final boolean IS_OS_WINDOWS_MODERN = LookUtils.startsWith(OS_NAME, "Windows") && !LookUtils.startsWith(OS_VERSION, "4.0");
    public static final boolean IS_OS_WINDOWS_95 = LookUtils.startsWith(OS_NAME, "Windows 9") && LookUtils.startsWith(OS_VERSION, "4.0");
    public static final boolean IS_OS_WINDOWS_NT = LookUtils.startsWith(OS_NAME, "Windows NT");
    private static boolean loggingEnabled = true;

    private LookUtils() {
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            LookUtils.log("Can't read the System property " + key + ".");
            return null;
        }
    }

    public static String getSystemProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            LookUtils.log("Can't read the System property " + key + ".");
            return defaultValue;
        }
    }

    public static Boolean getBooleanSystemProperty(String key, String logMessage) {
        String value = LookUtils.getSystemProperty(key, "");
        Boolean result = value.equalsIgnoreCase("false") ? Boolean.FALSE : (value.equalsIgnoreCase("true") ? Boolean.TRUE : null);
        if (result != null) {
            LookUtils.log(logMessage + " have been " + (result != false ? "en" : "dis") + "abled in the system properties.");
        }
        return result;
    }

    public static boolean isTrueColor(Component c) {
        return c.getToolkit().getColorModel().getPixelSize() >= 24;
    }

    public static boolean getToolkitUsesNativeDropShadows() {
        return IS_OS_MAC;
    }

    public static Color getSlightlyBrighter(Color color) {
        return LookUtils.getSlightlyBrighter(color, 1.1f);
    }

    public static Color getSlightlyBrighter(Color color, float factor) {
        float[] hsbValues = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbValues);
        float hue = hsbValues[0];
        float saturation = hsbValues[1];
        float brightness = hsbValues[2];
        float newBrightness = Math.min(brightness * factor, 1.0f);
        return Color.getHSBColor(hue, saturation, newBrightness);
    }

    public static void setLookAndTheme(LookAndFeel laf, Object theme) throws UnsupportedLookAndFeelException {
        if (laf instanceof PlasticLookAndFeel && theme != null && theme instanceof PlasticTheme) {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)theme);
        }
        UIManager.setLookAndFeel(laf);
    }

    public static Object getDefaultTheme(LookAndFeel laf) {
        return laf instanceof PlasticLookAndFeel ? PlasticLookAndFeel.createMyDefaultTheme() : null;
    }

    public static List getInstalledThemes(LookAndFeel laf) {
        return laf instanceof PlasticLookAndFeel ? PlasticLookAndFeel.getInstalledThemes() : Collections.EMPTY_LIST;
    }

    public static void setLoggingEnabled(boolean enabled) {
        loggingEnabled = enabled;
    }

    public static void log() {
        if (loggingEnabled) {
            System.out.println();
        }
    }

    public static void log(String message) {
        if (loggingEnabled) {
            System.out.println("JGoodies Looks: " + message);
        }
    }
}

