/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.progress.BackgroundTask;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginInstaller;
import org.protege.editor.core.update.PluginPanel;
import org.protege.editor.core.update.PluginRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final String LAST_RUN_PREFS_KEY = "last.run";
    private static final PluginManager instance = new PluginManager();
    public static final String AUTO_UPDATE_KEY = "CheckForUpdates";
    public static final String PLUGIN_REGISTRY_KEY = "plugin.registry-5.0.url";
    public static final String DEFAULT_REGISTRY = "https://raw.githubusercontent.com/protegeproject/autoupdate/master/update-info/5.0.0/plugins.repository";
    private final Logger logger = LoggerFactory.getLogger(PluginManager.class);

    private PluginManager() {
    }

    public static synchronized PluginManager getInstance() {
        return instance;
    }

    private Preferences getPrefs() {
        PreferencesManager man = PreferencesManager.getInstance();
        return man.getApplicationPreferences(PluginManager.class);
    }

    public void setAutoUpdateEnabled(boolean b) {
        this.getPrefs().putBoolean(AUTO_UPDATE_KEY, b);
    }

    public boolean isAutoUpdateEnabled() {
        return this.getPrefs().getBoolean(AUTO_UPDATE_KEY, true);
    }

    public URL getPluginRegistryLocation() {
        String pluginRegistryLoc = this.getPrefs().getString(PLUGIN_REGISTRY_KEY, DEFAULT_REGISTRY);
        try {
            return new URL(pluginRegistryLoc);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPluginRegistryLocation(URL url) {
        String oldPluginRegistryLoc = this.getPrefs().getString(PLUGIN_REGISTRY_KEY, DEFAULT_REGISTRY);
        String newPluginRegistryLoc = url.toString();
        if (!newPluginRegistryLoc.equals(oldPluginRegistryLoc)) {
            this.getPrefs().putString(PLUGIN_REGISTRY_KEY, newPluginRegistryLoc);
        }
    }

    public Date getLastAutoUpdateDate() {
        long lastRun = this.getPrefs().getLong(LAST_RUN_PREFS_KEY, 0L);
        return new Date(lastRun);
    }

    public void runAutoUpdate() {
        this.runSearch(SearchType.UPDATES_ONLY);
    }

    public void runCheckForPlugins() throws IOException {
        this.ensureConnectionToPluginRegistry();
        this.runSearch(SearchType.UPDATES_AND_INSTALLS);
    }

    private void ensureConnectionToPluginRegistry() throws IOException {
        URL registryLocation = this.getPluginRegistryLocation();
        HttpURLConnection connection = (HttpURLConnection)registryLocation.openConnection();
        connection.setRequestMethod("HEAD");
        connection.getResponseCode();
    }

    private void runSearch(SearchType searchType) {
        BackgroundTask autoUpdateTask = ProtegeApplication.getBackgroundTaskManager().startTask("autoupdate");
        Runnable runnable = () -> {
            PluginRegistryImpl registry = new PluginRegistryImpl(this.getPluginRegistryLocation());
            try {
                registry.reload();
                this.getPrefs().putLong(LAST_RUN_PREFS_KEY, System.currentTimeMillis());
            }
            finally {
                ProtegeApplication.getBackgroundTaskManager().endTask(autoUpdateTask);
                List<PluginInfo> availablePlugins = registry.getAvailablePlugins();
                if (searchType == SearchType.UPDATES_AND_INSTALLS) {
                    this.showPluginsDialog(availablePlugins);
                } else if (!availablePlugins.isEmpty()) {
                    this.showPluginsDialog(availablePlugins);
                }
            }
        };
        Thread t = new Thread(runnable, "Auto-Update");
        t.setPriority(1);
        t.start();
    }

    private void showPluginsDialog(List<PluginInfo> pluginInfoList) {
        SwingUtilities.invokeLater(() -> {
            List<PluginInfo> selUpdates = PluginPanel.showDialog(pluginInfoList, null);
            if (!selUpdates.isEmpty()) {
                PluginInstaller installer = new PluginInstaller(selUpdates);
                installer.run();
            }
        });
    }

    private static enum SearchType {
        UPDATES_ONLY,
        UPDATES_AND_INSTALLS;

    }
}

