# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (ImportError, SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

class PhotoSourceArg(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar str account.PhotoSourceArg.base64_data: Image data in base64-encoded
        bytes.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def base64_data(cls, val):
        """
        Create an instance of this class set to the ``base64_data`` tag with
        value ``val``.

        :param str val:
        :rtype: PhotoSourceArg
        """
        return cls('base64_data', val)

    def is_base64_data(self):
        """
        Check if the union tag is ``base64_data``.

        :rtype: bool
        """
        return self._tag == 'base64_data'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_base64_data(self):
        """
        Image data in base64-encoded bytes.

        Only call this if :meth:`is_base64_data` is true.

        :rtype: str
        """
        if not self.is_base64_data():
            raise AttributeError("tag 'base64_data' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(PhotoSourceArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'PhotoSourceArg(%r, %r)' % (self._tag, self._value)

PhotoSourceArg_validator = bv.Union(PhotoSourceArg)

class SetProfilePhotoArg(bb.Struct):
    """
    :ivar account.SetProfilePhotoArg.photo: Image to set as the user's new
        profile photo.
    """

    __slots__ = [
        '_photo_value',
        '_photo_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 photo=None):
        self._photo_value = None
        self._photo_present = False
        if photo is not None:
            self.photo = photo

    @property
    def photo(self):
        """
        Image to set as the user's new profile photo.

        :rtype: PhotoSourceArg
        """
        if self._photo_present:
            return self._photo_value
        else:
            raise AttributeError("missing required field 'photo'")

    @photo.setter
    def photo(self, val):
        self._photo_validator.validate_type_only(val)
        self._photo_value = val
        self._photo_present = True

    @photo.deleter
    def photo(self):
        self._photo_value = None
        self._photo_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(SetProfilePhotoArg, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'SetProfilePhotoArg(photo={!r})'.format(
            self._photo_value,
        )

SetProfilePhotoArg_validator = bv.Struct(SetProfilePhotoArg)

class SetProfilePhotoError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar account.SetProfilePhotoError.file_type_error: File cannot be set as
        profile photo.
    :ivar account.SetProfilePhotoError.file_size_error: File cannot exceed 10
        MB.
    :ivar account.SetProfilePhotoError.dimension_error: Image must be larger
        than 128 x 128.
    :ivar account.SetProfilePhotoError.thumbnail_error: Image could not be
        thumbnailed.
    :ivar account.SetProfilePhotoError.transient_error: Temporary infrastructure
        failure, please retry.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    file_type_error = None
    # Attribute is overwritten below the class definition
    file_size_error = None
    # Attribute is overwritten below the class definition
    dimension_error = None
    # Attribute is overwritten below the class definition
    thumbnail_error = None
    # Attribute is overwritten below the class definition
    transient_error = None
    # Attribute is overwritten below the class definition
    other = None

    def is_file_type_error(self):
        """
        Check if the union tag is ``file_type_error``.

        :rtype: bool
        """
        return self._tag == 'file_type_error'

    def is_file_size_error(self):
        """
        Check if the union tag is ``file_size_error``.

        :rtype: bool
        """
        return self._tag == 'file_size_error'

    def is_dimension_error(self):
        """
        Check if the union tag is ``dimension_error``.

        :rtype: bool
        """
        return self._tag == 'dimension_error'

    def is_thumbnail_error(self):
        """
        Check if the union tag is ``thumbnail_error``.

        :rtype: bool
        """
        return self._tag == 'thumbnail_error'

    def is_transient_error(self):
        """
        Check if the union tag is ``transient_error``.

        :rtype: bool
        """
        return self._tag == 'transient_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(SetProfilePhotoError, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'SetProfilePhotoError(%r, %r)' % (self._tag, self._value)

SetProfilePhotoError_validator = bv.Union(SetProfilePhotoError)

class SetProfilePhotoResult(bb.Struct):
    """
    :ivar account.SetProfilePhotoResult.profile_photo_url: URL for the photo
        representing the user, if one is set.
    """

    __slots__ = [
        '_profile_photo_url_value',
        '_profile_photo_url_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 profile_photo_url=None):
        self._profile_photo_url_value = None
        self._profile_photo_url_present = False
        if profile_photo_url is not None:
            self.profile_photo_url = profile_photo_url

    @property
    def profile_photo_url(self):
        """
        URL for the photo representing the user, if one is set.

        :rtype: str
        """
        if self._profile_photo_url_present:
            return self._profile_photo_url_value
        else:
            raise AttributeError("missing required field 'profile_photo_url'")

    @profile_photo_url.setter
    def profile_photo_url(self, val):
        val = self._profile_photo_url_validator.validate(val)
        self._profile_photo_url_value = val
        self._profile_photo_url_present = True

    @profile_photo_url.deleter
    def profile_photo_url(self):
        self._profile_photo_url_value = None
        self._profile_photo_url_present = False

    def _process_custom_annotations(self, annotation_type, field_path, processor):
        super(SetProfilePhotoResult, self)._process_custom_annotations(annotation_type, field_path, processor)

    def __repr__(self):
        return 'SetProfilePhotoResult(profile_photo_url={!r})'.format(
            self._profile_photo_url_value,
        )

SetProfilePhotoResult_validator = bv.Struct(SetProfilePhotoResult)

PhotoSourceArg._base64_data_validator = bv.String()
PhotoSourceArg._other_validator = bv.Void()
PhotoSourceArg._tagmap = {
    'base64_data': PhotoSourceArg._base64_data_validator,
    'other': PhotoSourceArg._other_validator,
}

PhotoSourceArg.other = PhotoSourceArg('other')

SetProfilePhotoArg._photo_validator = PhotoSourceArg_validator
SetProfilePhotoArg._all_field_names_ = set(['photo'])
SetProfilePhotoArg._all_fields_ = [('photo', SetProfilePhotoArg._photo_validator)]

SetProfilePhotoError._file_type_error_validator = bv.Void()
SetProfilePhotoError._file_size_error_validator = bv.Void()
SetProfilePhotoError._dimension_error_validator = bv.Void()
SetProfilePhotoError._thumbnail_error_validator = bv.Void()
SetProfilePhotoError._transient_error_validator = bv.Void()
SetProfilePhotoError._other_validator = bv.Void()
SetProfilePhotoError._tagmap = {
    'file_type_error': SetProfilePhotoError._file_type_error_validator,
    'file_size_error': SetProfilePhotoError._file_size_error_validator,
    'dimension_error': SetProfilePhotoError._dimension_error_validator,
    'thumbnail_error': SetProfilePhotoError._thumbnail_error_validator,
    'transient_error': SetProfilePhotoError._transient_error_validator,
    'other': SetProfilePhotoError._other_validator,
}

SetProfilePhotoError.file_type_error = SetProfilePhotoError('file_type_error')
SetProfilePhotoError.file_size_error = SetProfilePhotoError('file_size_error')
SetProfilePhotoError.dimension_error = SetProfilePhotoError('dimension_error')
SetProfilePhotoError.thumbnail_error = SetProfilePhotoError('thumbnail_error')
SetProfilePhotoError.transient_error = SetProfilePhotoError('transient_error')
SetProfilePhotoError.other = SetProfilePhotoError('other')

SetProfilePhotoResult._profile_photo_url_validator = bv.String()
SetProfilePhotoResult._all_field_names_ = set(['profile_photo_url'])
SetProfilePhotoResult._all_fields_ = [('profile_photo_url', SetProfilePhotoResult._profile_photo_url_validator)]

set_profile_photo = bb.Route(
    'set_profile_photo',
    1,
    False,
    SetProfilePhotoArg_validator,
    SetProfilePhotoResult_validator,
    SetProfilePhotoError_validator,
    {'host': u'api',
     'style': u'rpc'},
)

ROUTES = {
    'set_profile_photo': set_profile_photo,
}

