/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.livejvm;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.utilities.Assert;

class JNIHandleAccessor {
    private Address addr;
    private ObjectHeap heap;

    JNIHandleAccessor(Address addr, ObjectHeap heap) {
        this.addr = addr;
        this.heap = heap;
    }

    Oop getValue() {
        Address handle = this.addr.getAddressAt(0L);
        if (handle == null) {
            return null;
        }
        return this.heap.newOop(handle.getOopHandleAt(0L));
    }

    void setValue(Oop value) {
        Address handle = this.addr.getAddressAt(0L);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(handle != null, "Must have valid global JNI handle for setting");
        }
        handle.setOopHandleAt(0L, value.getHandle());
    }
}

