/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.security.Permission;
import java.security.cert.Certificate;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.Cache;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class CachedResource
implements WebResource {
    private static final Log log = LogFactory.getLog(CachedResource.class);
    private static final StringManager sm = StringManager.getManager(CachedResource.class);
    private static final long CACHE_ENTRY_SIZE = 500L;
    private final Cache cache;
    private final StandardRoot root;
    private final String webAppPath;
    private final long ttl;
    private final int objectMaxSizeBytes;
    private final boolean usesClassLoaderResources;
    private volatile WebResource webResource;
    private volatile WebResource[] webResources;
    private volatile long nextCheck;
    private volatile Long cachedLastModified = null;
    private volatile String cachedLastModifiedHttp = null;
    private volatile byte[] cachedContent = null;
    private volatile Boolean cachedIsFile = null;
    private volatile Boolean cachedIsDirectory = null;
    private volatile Boolean cachedExists = null;
    private volatile Boolean cachedIsVirtual = null;
    private volatile Long cachedContentLength = null;

    public CachedResource(Cache cache, StandardRoot standardRoot, String string, long l, int n, boolean bl) {
        this.cache = cache;
        this.root = standardRoot;
        this.webAppPath = string;
        this.ttl = l;
        this.objectMaxSizeBytes = n;
        this.usesClassLoaderResources = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateResource(boolean bl) {
        WebResource webResource;
        if (this.usesClassLoaderResources != bl) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (this.webResource == null) {
            webResource = this;
            synchronized (webResource) {
                if (this.webResource == null) {
                    this.webResource = this.root.getResourceInternal(this.webAppPath, bl);
                    this.getLastModified();
                    this.getContentLength();
                    this.nextCheck = this.ttl + l;
                    this.cachedExists = this.webResource instanceof EmptyResource ? Boolean.FALSE : Boolean.TRUE;
                    return true;
                }
            }
        }
        if (l < this.nextCheck) {
            return true;
        }
        if (!this.root.isPackedWarFile()) {
            webResource = this.root.getResourceInternal(this.webAppPath, bl);
            if (!this.webResource.exists() && webResource.exists()) {
                return false;
            }
            if (this.webResource.getLastModified() != this.getLastModified() || this.webResource.getContentLength() != this.getContentLength()) {
                return false;
            }
            if (this.webResource.getLastModified() != webResource.getLastModified() || this.webResource.getContentLength() != webResource.getContentLength()) {
                return false;
            }
        }
        this.nextCheck = this.ttl + l;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateResources(boolean bl) {
        long l = System.currentTimeMillis();
        if (this.webResources == null) {
            CachedResource cachedResource = this;
            synchronized (cachedResource) {
                if (this.webResources == null) {
                    this.webResources = this.root.getResourcesInternal(this.webAppPath, bl);
                    this.nextCheck = this.ttl + l;
                    return true;
                }
            }
        }
        if (l < this.nextCheck) {
            return true;
        }
        if (this.root.isPackedWarFile()) {
            this.nextCheck = this.ttl + l;
            return true;
        }
        return false;
    }

    protected long getNextCheck() {
        return this.nextCheck;
    }

    @Override
    public long getLastModified() {
        Long l = this.cachedLastModified;
        if (l == null) {
            this.cachedLastModified = l = Long.valueOf(this.webResource.getLastModified());
        }
        return l;
    }

    @Override
    public String getLastModifiedHttp() {
        String string = this.cachedLastModifiedHttp;
        if (string == null) {
            this.cachedLastModifiedHttp = string = this.webResource.getLastModifiedHttp();
        }
        return string;
    }

    @Override
    public boolean exists() {
        Boolean bl = this.cachedExists;
        if (bl == null) {
            this.cachedExists = bl = Boolean.valueOf(this.webResource.exists());
        }
        return bl;
    }

    @Override
    public boolean isVirtual() {
        Boolean bl = this.cachedIsVirtual;
        if (bl == null) {
            this.cachedIsVirtual = bl = Boolean.valueOf(this.webResource.isVirtual());
        }
        return bl;
    }

    @Override
    public boolean isDirectory() {
        Boolean bl = this.cachedIsDirectory;
        if (bl == null) {
            this.cachedIsDirectory = bl = Boolean.valueOf(this.webResource.isDirectory());
        }
        return bl;
    }

    @Override
    public boolean isFile() {
        Boolean bl = this.cachedIsFile;
        if (bl == null) {
            this.cachedIsFile = bl = Boolean.valueOf(this.webResource.isFile());
        }
        return bl;
    }

    @Override
    public boolean delete() {
        boolean bl = this.webResource.delete();
        if (bl) {
            this.cache.removeCacheEntry(this.webAppPath);
        }
        return bl;
    }

    @Override
    public String getName() {
        return this.webResource.getName();
    }

    @Override
    public long getContentLength() {
        Long l = this.cachedContentLength;
        if (l == null) {
            long l2 = 0L;
            if (this.webResource != null) {
                l2 = this.webResource.getContentLength();
                this.cachedContentLength = l = Long.valueOf(l2);
            }
            return l2;
        }
        return l;
    }

    @Override
    public String getCanonicalPath() {
        return this.webResource.getCanonicalPath();
    }

    @Override
    public boolean canRead() {
        return this.webResource.canRead();
    }

    @Override
    public String getWebappPath() {
        return this.webAppPath;
    }

    @Override
    public String getETag() {
        return this.webResource.getETag();
    }

    @Override
    public void setMimeType(String string) {
        this.webResource.setMimeType(string);
    }

    @Override
    public String getMimeType() {
        return this.webResource.getMimeType();
    }

    @Override
    public InputStream getInputStream() {
        byte[] byArray = this.getContent();
        if (byArray == null) {
            return this.webResource.getInputStream();
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public byte[] getContent() {
        byte[] byArray = this.cachedContent;
        if (byArray == null) {
            if (this.getContentLength() > (long)this.objectMaxSizeBytes) {
                return null;
            }
            this.cachedContent = byArray = this.webResource.getContent();
        }
        return byArray;
    }

    @Override
    public long getCreation() {
        return this.webResource.getCreation();
    }

    @Override
    public URL getURL() {
        URL uRL = this.webResource.getURL();
        if (uRL == null) {
            return null;
        }
        try {
            CachedResourceURLStreamHandler cachedResourceURLStreamHandler = new CachedResourceURLStreamHandler(uRL, this.root, this.webAppPath, this.usesClassLoaderResources);
            URL uRL2 = new URL(null, uRL.toExternalForm(), cachedResourceURLStreamHandler);
            cachedResourceURLStreamHandler.setAssociatedURL(uRL2);
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)sm.getString("cachedResource.invalidURL", new Object[]{uRL.toExternalForm()}), (Throwable)malformedURLException);
            return null;
        }
    }

    @Override
    public URL getCodeBase() {
        return this.webResource.getCodeBase();
    }

    @Override
    public Certificate[] getCertificates() {
        return this.webResource.getCertificates();
    }

    @Override
    public Manifest getManifest() {
        return this.webResource.getManifest();
    }

    @Override
    public WebResourceRoot getWebResourceRoot() {
        return this.webResource.getWebResourceRoot();
    }

    WebResource getWebResource() {
        return this.webResource;
    }

    WebResource[] getWebResources() {
        return this.webResources;
    }

    boolean usesClassLoaderResources() {
        return this.usesClassLoaderResources;
    }

    long getSize() {
        long l = 500L;
        l += (long)(this.getWebappPath().length() * 2);
        if (this.getContentLength() <= (long)this.objectMaxSizeBytes) {
            l += this.getContentLength();
        }
        return l;
    }

    private static InputStream buildInputStream(String[] stringArray) {
        Arrays.sort(stringArray, Collator.getInstance(Locale.getDefault()));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return new ByteArrayInputStream(stringBuilder.toString().getBytes(Charset.defaultCharset()));
    }

    private static class CachedResourceJarURLConnection
    extends JarURLConnection {
        private final StandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private final URL resourceURL;

        protected CachedResourceJarURLConnection(URL uRL, StandardRoot standardRoot, String string, boolean bl) throws IOException {
            super(uRL);
            this.root = standardRoot;
            this.webAppPath = string;
            this.usesClassLoaderResources = bl;
            this.resourceURL = uRL;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            WebResource webResource = this.getResource();
            if (webResource.isDirectory()) {
                return CachedResource.buildInputStream(webResource.getWebResourceRoot().list(this.webAppPath));
            }
            return this.getResource().getInputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.resourceURL.openConnection().getPermission();
        }

        @Override
        public long getLastModified() {
            return this.getResource().getLastModified();
        }

        @Override
        public long getContentLengthLong() {
            return this.getResource().getContentLength();
        }

        private WebResource getResource() {
            return this.root.getResource(this.webAppPath, false, this.usesClassLoaderResources);
        }

        @Override
        public JarFile getJarFile() throws IOException {
            return ((JarURLConnection)this.resourceURL.openConnection()).getJarFile();
        }

        @Override
        public JarEntry getJarEntry() throws IOException {
            if (this.getEntryName() == null) {
                return null;
            }
            return super.getJarEntry();
        }
    }

    private static class CachedResourceURLConnection
    extends URLConnection {
        private final StandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private final URL resourceURL;

        protected CachedResourceURLConnection(URL uRL, StandardRoot standardRoot, String string, boolean bl) {
            super(uRL);
            this.root = standardRoot;
            this.webAppPath = string;
            this.usesClassLoaderResources = bl;
            this.resourceURL = uRL;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            WebResource webResource = this.getResource();
            if (webResource.isDirectory()) {
                return CachedResource.buildInputStream(webResource.getWebResourceRoot().list(this.webAppPath));
            }
            return this.getResource().getInputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.resourceURL.openConnection().getPermission();
        }

        @Override
        public long getLastModified() {
            return this.getResource().getLastModified();
        }

        @Override
        public long getContentLengthLong() {
            return this.getResource().getContentLength();
        }

        private WebResource getResource() {
            return this.root.getResource(this.webAppPath, false, this.usesClassLoaderResources);
        }
    }

    private static class CachedResourceURLStreamHandler
    extends URLStreamHandler {
        private final URL resourceURL;
        private final StandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private URL associatedURL = null;

        public CachedResourceURLStreamHandler(URL uRL, StandardRoot standardRoot, String string, boolean bl) {
            this.resourceURL = uRL;
            this.root = standardRoot;
            this.webAppPath = string;
            this.usesClassLoaderResources = bl;
        }

        protected void setAssociatedURL(URL uRL) {
            this.associatedURL = uRL;
        }

        @Override
        protected URLConnection openConnection(URL uRL) throws IOException {
            if (this.associatedURL != null && uRL == this.associatedURL) {
                if ("jar".equals(this.associatedURL.getProtocol())) {
                    return new CachedResourceJarURLConnection(this.resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
                }
                return new CachedResourceURLConnection(this.resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
            }
            URL uRL2 = new URL(uRL.toExternalForm());
            return uRL2.openConnection();
        }
    }
}

