/**
 * SECTION:extended-info
 * @short_description: Object representing an arbitrary field that can have some parameters associated with it. This is intended to be as general-purpose as, for example, a vCard property. See the documentation for <link linkend="FolksExtendedInfo"><type>FolksExtendedInfo</type></link> for information on when using this object is appropriate.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.11.0
 */
/**
 * FOLKS_TYPE_EXTENDED_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksExtendedFieldDetails"><type>FolksExtendedFieldDetails</type></link>.
 */
/**
 * folks_extended_field_details_new:
 * @value: (in): &nbsp;.  <para>the value of the field, which may be the empty string </para>
 * @parameters: (in) (allow-none): &nbsp;.  <para>initial parameters. See <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>. A <code>null</code> value is equivalent to an empty map of parameters. </para>
 * 
 * Create a new ExtendedFieldDetails.
 * 
 * Returns: <para>a new ExtendedFieldDetails </para>
 *
 * Since: 0.11.0
 */
/**
 * FolksExtendedFieldDetails:
 * 
 * Object representing an arbitrary field that can have some parameters associated with it. This is intended to be as general-purpose as, for example, a vCard property. See the documentation for <link linkend="FolksExtendedInfo"><type>FolksExtendedInfo</type></link> for information on when using this object is appropriate.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.11.0
 */
/**
 * FolksExtendedFieldDetailsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-EXTENDED-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_EXTENDED_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_extended_info_get_extended_field:
 * @self: the <link linkend="FolksExtendedInfo"><type>FolksExtendedInfo</type></link> instance
 * @name: &nbsp;
 * 
 * Retrieve the value for an arbitrary field.
 * 
 * Returns: <para>The value of the extended field, which may be empty, or `null` if the field is not set </para>
 *
 * Since: 0.11.0
 */
/**
 * folks_extended_info_change_extended_field:
 * @self: the <link linkend="FolksExtendedInfo"><type>FolksExtendedInfo</type></link> instance
 * @name: (in): &nbsp;.  <para>name of the arbitrary field to change value </para>
 * @value: (in): &nbsp;.  <para>new value for the arbitrary field </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the value of an arbitrary field.
 * 
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the value failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-extended-info-change-extended-field-finish"><function>folks_extended_info_change_extended_field_finish()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_extended_info_change_extended_field_finish:
 * @self: the <link linkend="FolksExtendedInfo"><type>FolksExtendedInfo</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the value of an arbitrary field.
 * 
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the value failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-extended-info-change-extended-field"><function>folks_extended_info_change_extended_field()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_extended_info_remove_extended_field:
 * @self: the <link linkend="FolksExtendedInfo"><type>FolksExtendedInfo</type></link> instance
 * @name: (in): &nbsp;.  <para>name of the arbitrary field to remove </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Remove an arbitrary field.
 * 
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if removing the property failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-extended-info-remove-extended-field-finish"><function>folks_extended_info_remove_extended_field_finish()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * folks_extended_info_remove_extended_field_finish:
 * @self: the <link linkend="FolksExtendedInfo"><type>FolksExtendedInfo</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Remove an arbitrary field.
 * 
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if removing the property failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-extended-info-remove-extended-field"><function>folks_extended_info_remove_extended_field()</function></link>
 *
 * Since: 0.11.0
 */
/**
 * FolksExtendedInfo:
 * 
 * Arbitrary field interface.
 * 
 * <para>This interface allows clients to store arbitrary fields for contacts in backends that support it.</para><para>This interface should be used for application-specific data, in which case the application should use the vCard approach to prefixing non-standard property names: `X-[APPLICATION NAME]-*’. Note that this is a global namespace, shared between all consumers of the backend’s data, so please namespace application-specific data with the application’s name.</para><para>This interface should not be used for more general-purpose data which could be better represented with a type-safe interface implemented in libfolks. It must not be used for data which is already represented with a type-safe interface in libfolks.</para><para>A good example of data which could be stored on this interface is an e-mail application’s setting of whether a content prefers to receive HTML or plaintext e-mail.</para><para>A good example of data which should not be stored on this interface is a contact’s anniversary. That should be added in a separate interface in libfolks.</para>
 *
 * Since: 0.11.0
 */
/**
 * FolksExtendedInfoIface:
 * @get_extended_field: virtual method called by <link linkend="folks-extended-info-get-extended-field"><function>folks_extended_info_get_extended_field()</function></link>
 * @change_extended_field: virtual method called by <link linkend="folks-extended-info-change-extended-field"><function>folks_extended_info_change_extended_field()</function></link>
 * @change_extended_field_finish: asynchronous finish function for <structfield>change_extended_field</structfield>, called by <link linkend="folks-extended-info-change-extended-field"><function>folks_extended_info_change_extended_field()</function></link>
 * @remove_extended_field: virtual method called by <link linkend="folks-extended-info-remove-extended-field"><function>folks_extended_info_remove_extended_field()</function></link>
 * @remove_extended_field_finish: asynchronous finish function for <structfield>remove_extended_field</structfield>, called by <link linkend="folks-extended-info-remove-extended-field"><function>folks_extended_info_remove_extended_field()</function></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksExtendedInfo"><type>FolksExtendedInfo</type></link> implementations.
 */
