/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.WebConnection;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.server.WsFrameServer;
import org.apache.tomcat.websocket.server.WsHandshakeRequest;
import org.apache.tomcat.websocket.server.WsRemoteEndpointImplServer;
import org.apache.tomcat.websocket.server.WsServerContainer;

public class WsHttpUpgradeHandler
implements InternalHttpUpgradeHandler {
    private final Log log = LogFactory.getLog(WsHttpUpgradeHandler.class);
    private static final StringManager sm = StringManager.getManager(WsHttpUpgradeHandler.class);
    private final ClassLoader applicationClassLoader;
    private SocketWrapperBase<?> socketWrapper;
    private UpgradeInfo upgradeInfo = new UpgradeInfo();
    private Endpoint ep;
    private ServerEndpointConfig serverEndpointConfig;
    private WsServerContainer webSocketContainer;
    private WsHandshakeRequest handshakeRequest;
    private List<Extension> negotiatedExtensions;
    private String subProtocol;
    private Transformation transformation;
    private Map<String, String> pathParameters;
    private boolean secure;
    private WebConnection connection;
    private WsRemoteEndpointImplServer wsRemoteEndpointServer;
    private WsFrameServer wsFrame;
    private WsSession wsSession;

    public WsHttpUpgradeHandler() {
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void setSocketWrapper(SocketWrapperBase<?> socketWrapperBase) {
        this.socketWrapper = socketWrapperBase;
    }

    public void preInit(Endpoint endpoint, ServerEndpointConfig serverEndpointConfig, WsServerContainer wsServerContainer, WsHandshakeRequest wsHandshakeRequest, List<Extension> list, String string, Transformation transformation, Map<String, String> map, boolean bl) {
        this.ep = endpoint;
        this.serverEndpointConfig = serverEndpointConfig;
        this.webSocketContainer = wsServerContainer;
        this.handshakeRequest = wsHandshakeRequest;
        this.negotiatedExtensions = list;
        this.subProtocol = string;
        this.transformation = transformation;
        this.pathParameters = map;
        this.secure = bl;
    }

    public void init(WebConnection webConnection) {
        if (this.ep == null) {
            throw new IllegalStateException(sm.getString("wsHttpUpgradeHandler.noPreInit"));
        }
        String string = null;
        Object object = this.handshakeRequest.getHttpSession();
        if (object != null) {
            string = ((HttpSession)object).getId();
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.wsRemoteEndpointServer = new WsRemoteEndpointImplServer(this.socketWrapper, this.upgradeInfo, this.webSocketContainer);
            this.wsSession = new WsSession(this.ep, this.wsRemoteEndpointServer, this.webSocketContainer, this.handshakeRequest.getRequestURI(), this.handshakeRequest.getParameterMap(), this.handshakeRequest.getQueryString(), this.handshakeRequest.getUserPrincipal(), string, this.negotiatedExtensions, this.subProtocol, this.pathParameters, this.secure, (EndpointConfig)this.serverEndpointConfig);
            this.wsFrame = new WsFrameServer(this.socketWrapper, this.upgradeInfo, this.wsSession, this.transformation, this.applicationClassLoader);
            this.wsRemoteEndpointServer.setTransformation(this.wsFrame.getTransformation());
            this.ep.onOpen((Session)this.wsSession, (EndpointConfig)this.serverEndpointConfig);
            this.webSocketContainer.registerSession(this.serverEndpointConfig.getPath(), this.wsSession);
        }
        catch (DeploymentException deploymentException) {
            throw new IllegalArgumentException(deploymentException);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    public UpgradeInfo getUpgradeInfo() {
        return this.upgradeInfo;
    }

    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketEvent socketEvent) {
        switch (socketEvent) {
            case OPEN_READ: {
                try {
                    return this.wsFrame.notifyDataAvailable();
                }
                catch (WsIOException wsIOException) {
                    this.close(wsIOException.getCloseReason());
                }
                catch (IOException iOException) {
                    this.onError(iOException);
                    CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, iOException.getMessage());
                    this.close(closeReason);
                }
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            case OPEN_WRITE: {
                this.wsRemoteEndpointServer.onWritePossible(false);
                break;
            }
            case STOP: {
                CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, sm.getString("wsHttpUpgradeHandler.serverStop"));
                try {
                    this.wsSession.close(closeReason);
                    break;
                }
                catch (IOException iOException) {
                    this.onError(iOException);
                    closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, iOException.getMessage());
                    this.close(closeReason);
                    return AbstractEndpoint.Handler.SocketState.CLOSED;
                }
            }
            case ERROR: {
                String string = sm.getString("wsHttpUpgradeHandler.closeOnError");
                this.wsSession.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, string), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, string));
            }
            case DISCONNECT: 
            case TIMEOUT: 
            case CONNECT_FAIL: {
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
        }
        if (this.wsFrame.isOpen()) {
            return AbstractEndpoint.Handler.SocketState.UPGRADED;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    public void timeoutAsync(long l) {
    }

    public void pause() {
    }

    public void destroy() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                this.log.error((Object)sm.getString("wsHttpUpgradeHandler.destroyFailed"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable throwable) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.ep.onError((Session)this.wsSession, throwable);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    private void close(CloseReason closeReason) {
        this.wsSession.onClose(closeReason);
    }

    public void setSslSupport(SSLSupport sSLSupport) {
    }
}

