/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class FlushableGZIPOutputStream
extends GZIPOutputStream {
    private byte[] lastByte = new byte[1];
    private boolean hasLastByte = false;
    private boolean flagReenableCompression = false;

    public FlushableGZIPOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            this.flushLastByte();
            if (n2 > 1) {
                this.reenableCompression();
                super.write(byArray, n, n2 - 1);
            }
            this.rememberLastByte(byArray[n + n2 - 1]);
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.flushLastByte();
        this.rememberLastByte((byte)n);
    }

    @Override
    public synchronized void finish() throws IOException {
        try {
            this.flushLastByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finish();
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.flushLastByte();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.close();
    }

    private void reenableCompression() {
        if (this.flagReenableCompression && !this.def.finished()) {
            this.flagReenableCompression = false;
            this.def.setLevel(-1);
        }
    }

    private void rememberLastByte(byte by) {
        this.lastByte[0] = by;
        this.hasLastByte = true;
    }

    private void flushLastByte() throws IOException {
        if (this.hasLastByte) {
            this.reenableCompression();
            this.hasLastByte = false;
            super.write(this.lastByte, 0, 1);
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.hasLastByte && !this.def.finished()) {
            this.def.setLevel(0);
            this.flushLastByte();
            this.flagReenableCompression = true;
        }
        this.out.flush();
    }

    @Override
    protected void deflate() throws IOException {
        int n;
        do {
            if ((n = this.def.deflate(this.buf, 0, this.buf.length)) <= 0) continue;
            this.out.write(this.buf, 0, n);
        } while (n != 0);
    }
}

