/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalAprOutputBuffer
extends AbstractOutputBuffer<Long> {
    private long socket;
    private ByteBuffer bbuf = null;

    public InternalAprOutputBuffer(Response response, int n) {
        this.response = response;
        this.buf = new byte[n];
        this.bbuf = n < 8192 ? ByteBuffer.allocateDirect(9000) : ByteBuffer.allocateDirect((n / 1500 + 1) * 1500);
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        HttpMessages.getInstance(response.getLocale()).getMessage(200);
    }

    @Override
    public void init(SocketWrapper<Long> socketWrapper, AbstractEndpoint<Long> abstractEndpoint) throws IOException {
        this.socket = socketWrapper.getSocket();
        Socket.setsbb(this.socket, this.bbuf);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.flushBuffer();
    }

    @Override
    public void recycle() {
        super.recycle();
        this.bbuf.clear();
    }

    @Override
    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.flushBuffer();
        this.finished = true;
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed && Socket.send(this.socket, Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length) < 0) {
            throw new IOException(sm.getString("iib.failedwrite"));
        }
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.bbuf.put(this.buf, 0, this.pos);
        }
    }

    private void flushBuffer() throws IOException {
        if (this.bbuf.position() > 0) {
            if (Socket.sendbb(this.socket, 0, this.bbuf.position()) < 0) {
                throw new IOException();
            }
            this.bbuf.clear();
        }
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk byteChunk, Response response) throws IOException {
            try {
                int n = byteChunk.getLength();
                int n2 = byteChunk.getStart();
                byte[] byArray = byteChunk.getBuffer();
                while (n > 0) {
                    int n3 = n;
                    if (InternalAprOutputBuffer.this.bbuf.position() == InternalAprOutputBuffer.this.bbuf.capacity()) {
                        InternalAprOutputBuffer.this.flushBuffer();
                    }
                    if (n3 > InternalAprOutputBuffer.this.bbuf.capacity() - InternalAprOutputBuffer.this.bbuf.position()) {
                        n3 = InternalAprOutputBuffer.this.bbuf.capacity() - InternalAprOutputBuffer.this.bbuf.position();
                    }
                    InternalAprOutputBuffer.this.bbuf.put(byArray, n2, n3);
                    n -= n3;
                    n2 += n3;
                }
                InternalAprOutputBuffer.this.byteCount += (long)byteChunk.getLength();
                return byteChunk.getLength();
            }
            catch (IOException iOException) {
                InternalAprOutputBuffer.this.response.action(ActionCode.CLOSE_NOW, iOException);
                throw iOException;
            }
        }

        @Override
        public long getBytesWritten() {
            return InternalAprOutputBuffer.this.byteCount;
        }
    }
}

