/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TcpFailureDetector
extends ChannelInterceptorBase {
    private static final Log log = LogFactory.getLog(TcpFailureDetector.class);
    protected static byte[] TCP_FAIL_DETECT = new byte[]{79, -89, 115, 72, 121, -126, 67, -55, -97, 111, -119, -128, -95, 91, 7, 20, 125, -39, 82, 91, -21, -15, 67, -102, -73, 126, -66, -113, -127, 103, 30, -74, 55, 21, -66, -121, 69, 126, 76, -88, -65, 10, 77, 19, 83, 56, 21, 50, 85, -10, -108, -73, 58, -6, 64, 120, -111, 4, 125, -41, 114, -124, -64, -43};
    @Deprecated
    protected boolean performConnectTest = true;
    protected long connectTimeout = 1000L;
    protected boolean performSendTest = true;
    protected boolean performReadTest = false;
    protected long readTestTimeout = 5000L;
    protected Membership membership = null;
    protected HashMap<Member, Long> removeSuspects = new HashMap();
    protected HashMap<Member, Long> addSuspects = new HashMap();
    protected int removeSuspectsTimeout = 300;

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        try {
            super.sendMessage(memberArray, channelMessage, interceptorPayload);
        }
        catch (ChannelException channelException) {
            ChannelException.FaultyMember[] faultyMemberArray;
            for (ChannelException.FaultyMember faultyMember : faultyMemberArray = channelException.getFaultyMembers()) {
                if (faultyMember.getCause() == null || faultyMember.getCause() instanceof RemoteProcessException) continue;
                this.memberDisappeared(faultyMember.getMember());
            }
            throw channelException;
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        boolean bl = true;
        if (this.okToProcess(channelMessage.getOptions())) {
            boolean bl2 = bl = channelMessage.getMessage().getLength() != TCP_FAIL_DETECT.length || !Arrays.equals(TCP_FAIL_DETECT, channelMessage.getMessage().getBytes());
        }
        if (bl) {
            super.messageReceived(channelMessage);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Received a failure detector packet:" + channelMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberAdded(Member member) {
        if (this.membership == null) {
            this.setupMembership();
        }
        boolean bl = false;
        Membership membership = this.membership;
        synchronized (membership) {
            if (this.removeSuspects.containsKey(member)) {
                this.removeSuspects.remove(member);
            } else if (this.membership.getMember(member) == null) {
                if (this.memberAlive(member)) {
                    this.membership.memberAlive((MemberImpl)member);
                    bl = true;
                } else {
                    this.addSuspects.put(member, System.currentTimeMillis());
                }
            }
        }
        if (bl) {
            super.memberAdded(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDisappeared(Member member) {
        if (this.membership == null) {
            this.setupMembership();
        }
        boolean bl = false;
        boolean bl2 = Arrays.equals(member.getCommand(), Member.SHUTDOWN_PAYLOAD);
        if (bl2) {
            Membership membership = this.membership;
            synchronized (membership) {
                if (!this.membership.contains(member)) {
                    return;
                }
                this.membership.removeMember((MemberImpl)member);
                this.removeSuspects.remove(member);
                if (member instanceof StaticMember) {
                    this.addSuspects.put(member, System.currentTimeMillis());
                }
            }
            super.memberDisappeared(member);
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Received memberDisappeared[" + member + "] message. Will verify."));
            }
            Membership membership = this.membership;
            synchronized (membership) {
                if (!this.membership.contains(member)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Verification complete. Member already disappeared[" + member + "]"));
                    }
                    return;
                }
                if (!this.memberAlive(member)) {
                    this.membership.removeMember((MemberImpl)member);
                    this.removeSuspects.remove(member);
                    if (member instanceof StaticMember) {
                        this.addSuspects.put(member, System.currentTimeMillis());
                    }
                    bl = true;
                } else {
                    this.removeSuspects.put(member, System.currentTimeMillis());
                }
            }
            if (bl) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Verification complete. Member disappeared[" + member + "]"));
                }
                super.memberDisappeared(member);
            } else if (log.isInfoEnabled()) {
                log.info((Object)("Verification complete. Member still alive[" + member + "]"));
            }
        }
    }

    @Override
    public boolean hasMembers() {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.hasMembers();
    }

    @Override
    public Member[] getMembers() {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.getMembers();
    }

    @Override
    public Member getMember(Member member) {
        if (this.membership == null) {
            this.setupMembership();
        }
        return this.membership.getMember(member);
    }

    @Override
    public Member getLocalMember(boolean bl) {
        return super.getLocalMember(bl);
    }

    @Override
    public void heartbeat() {
        super.heartbeat();
        this.checkMembers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMembers(boolean bl) {
        try {
            if (this.membership == null) {
                this.setupMembership();
            }
            Membership membership = this.membership;
            synchronized (membership) {
                if (!bl) {
                    this.performBasicCheck();
                } else {
                    this.performForcedCheck();
                }
            }
        }
        catch (Exception exception) {
            log.warn((Object)"Unable to perform heartbeat on the TcpFailureDetector.", (Throwable)exception);
        }
    }

    protected void performForcedCheck() {
        Member[] memberArray = super.getMembers();
        for (int i = 0; memberArray != null && i < memberArray.length; ++i) {
            if (this.memberAlive(memberArray[i])) {
                if (this.membership.memberAlive((MemberImpl)memberArray[i])) {
                    super.memberAdded(memberArray[i]);
                }
                this.addSuspects.remove(memberArray[i]);
                continue;
            }
            if (this.membership.getMember(memberArray[i]) == null) continue;
            this.membership.removeMember((MemberImpl)memberArray[i]);
            this.removeSuspects.remove(memberArray[i]);
            if (memberArray[i] instanceof StaticMember) {
                this.addSuspects.put(memberArray[i], System.currentTimeMillis());
            }
            super.memberDisappeared(memberArray[i]);
        }
    }

    protected void performBasicCheck() {
        MemberImpl[] memberImplArray;
        Member[] memberArray = super.getMembers();
        for (int i = 0; memberArray != null && i < memberArray.length; ++i) {
            if (this.addSuspects.containsKey(memberArray[i]) && this.membership.getMember(memberArray[i]) == null || !this.membership.memberAlive((MemberImpl)memberArray[i])) continue;
            if (this.memberAlive(memberArray[i])) {
                log.warn((Object)("Member added, even though we weren't notified:" + memberArray[i]));
                super.memberAdded(memberArray[i]);
                continue;
            }
            this.membership.removeMember((MemberImpl)memberArray[i]);
        }
        for (MemberImpl memberImpl : memberImplArray = this.removeSuspects.keySet().toArray(new MemberImpl[0])) {
            long l;
            int n;
            if (this.membership.getMember(memberImpl) != null && !this.memberAlive(memberImpl)) {
                this.membership.removeMember(memberImpl);
                if (memberImpl instanceof StaticMember) {
                    this.addSuspects.put(memberImpl, System.currentTimeMillis());
                }
                super.memberDisappeared(memberImpl);
                this.removeSuspects.remove(memberImpl);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Suspect member, confirmed dead.[" + memberImpl + "]"));
                continue;
            }
            if (this.removeSuspectsTimeout <= 0 || (n = (int)(((l = System.currentTimeMillis()) - this.removeSuspects.get(memberImpl)) / 1000L)) <= this.removeSuspectsTimeout) continue;
            this.removeSuspects.remove(memberImpl);
        }
        for (MemberImpl memberImpl : memberImplArray = this.addSuspects.keySet().toArray(new MemberImpl[0])) {
            if (this.membership.getMember(memberImpl) != null || !this.memberAlive(memberImpl)) continue;
            this.membership.memberAlive(memberImpl);
            super.memberAdded(memberImpl);
            this.addSuspects.remove(memberImpl);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Suspect member, confirmed alive.[" + memberImpl + "]"));
        }
    }

    protected synchronized void setupMembership() {
        if (this.membership == null) {
            this.membership = new Membership((MemberImpl)super.getLocalMember(true));
        }
    }

    protected boolean memberAlive(Member member) {
        return TcpFailureDetector.memberAlive(member, TCP_FAIL_DETECT, this.performSendTest, this.performReadTest, this.readTestTimeout, this.connectTimeout, this.getOptionFlag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean memberAlive(Member member, byte[] byArray, boolean bl, boolean bl2, long l, long l2, int n) {
        if (Arrays.equals(member.getCommand(), Member.SHUTDOWN_PAYLOAD)) {
            return false;
        }
        Socket socket = new Socket();
        try {
            InetAddress inetAddress = InetAddress.getByAddress(member.getHost());
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, member.getPort());
            socket.setSoTimeout((int)l);
            socket.connect(inetSocketAddress, (int)l2);
            if (bl) {
                ChannelData channelData = new ChannelData(true);
                channelData.setAddress(member);
                channelData.setMessage(new XByteBuffer(byArray, false));
                channelData.setTimestamp(System.currentTimeMillis());
                int n2 = n | 1;
                n2 = bl2 ? (n2 |= 2) : (n2 &= 0xFFFFFFFD);
                channelData.setOptions(n2);
                byte[] byArray2 = XByteBuffer.createDataPackage(channelData);
                socket.getOutputStream().write(byArray2);
                if (bl2) {
                    int n3 = socket.getInputStream().read(byArray2);
                    boolean bl3 = n3 > 0;
                    return bl3;
                }
            }
            boolean bl4 = true;
            return bl4;
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        catch (ConnectException connectException) {
        }
        catch (NoRouteToHostException noRouteToHostException) {
        }
        catch (Exception exception) {
            log.error((Object)("Unable to perform failure detection check, assuming member down.[" + member + "]"), (Throwable)exception);
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Deprecated
    public boolean getPerformConnectTest() {
        return this.performConnectTest;
    }

    public long getReadTestTimeout() {
        return this.readTestTimeout;
    }

    public boolean getPerformSendTest() {
        return this.performSendTest;
    }

    public boolean getPerformReadTest() {
        return this.performReadTest;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getRemoveSuspectsTimeout() {
        return this.removeSuspectsTimeout;
    }

    @Deprecated
    public void setPerformConnectTest(boolean bl) {
        this.performConnectTest = bl;
    }

    public void setPerformReadTest(boolean bl) {
        this.performReadTest = bl;
    }

    public void setPerformSendTest(boolean bl) {
        this.performSendTest = bl;
    }

    public void setReadTestTimeout(long l) {
        this.readTestTimeout = l;
    }

    public void setConnectTimeout(long l) {
        this.connectTimeout = l;
    }

    public void setRemoveSuspectsTimeout(int n) {
        this.removeSuspectsTimeout = n;
    }
}

