/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant.jmx;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.catalina.ant.jmx.Arg;
import org.apache.catalina.ant.jmx.JMXAccessorTask;
import org.apache.tools.ant.BuildException;

public class JMXAccessorCreateTask
extends JMXAccessorTask {
    private String className;
    private String classLoader;
    private List<Arg> args = new ArrayList<Arg>();
    private static final String info = "org.apache.catalina.ant.JMXAccessorCreateTask/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    public String getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(String string) {
        this.classLoader = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void addArg(Arg arg) {
        this.args.add(arg);
    }

    public List<Arg> getArgs() {
        return this.args;
    }

    public void setArgs(List<Arg> list) {
        this.args = list;
    }

    @Override
    public String jmxExecute(MBeanServerConnection mBeanServerConnection) throws Exception {
        if (this.getName() == null) {
            throw new BuildException("Must specify a 'name'");
        }
        if (this.className == null) {
            throw new BuildException("Must specify a 'className' for get");
        }
        return this.jmxCreate(mBeanServerConnection, this.getName());
    }

    protected String jmxCreate(MBeanServerConnection mBeanServerConnection, String string) throws Exception {
        String string2 = null;
        Object[] objectArray = null;
        String[] stringArray = null;
        if (this.args != null) {
            objectArray = new Object[this.args.size()];
            stringArray = new String[this.args.size()];
            for (int i = 0; i < this.args.size(); ++i) {
                Arg arg = this.args.get(i);
                if (arg.getType() == null) {
                    arg.setType("java.lang.String");
                    stringArray[i] = arg.getType();
                    objectArray[i] = arg.getValue();
                    continue;
                }
                stringArray[i] = arg.getType();
                objectArray[i] = this.convertStringToType(arg.getValue(), arg.getType());
            }
        }
        if (this.classLoader != null && !"".equals(this.classLoader)) {
            if (this.isEcho()) {
                this.handleOutput("create MBean " + string + " from class " + this.className + " with classLoader " + this.classLoader);
            }
            if (this.args == null) {
                mBeanServerConnection.createMBean(this.className, new ObjectName(string), new ObjectName(this.classLoader));
            } else {
                mBeanServerConnection.createMBean(this.className, new ObjectName(string), new ObjectName(this.classLoader), objectArray, stringArray);
            }
        } else {
            if (this.isEcho()) {
                this.handleOutput("create MBean " + string + " from class " + this.className);
            }
            if (this.args == null) {
                mBeanServerConnection.createMBean(this.className, new ObjectName(string));
            } else {
                mBeanServerConnection.createMBean(this.className, new ObjectName(string), objectArray, stringArray);
            }
        }
        return string2;
    }
}

