/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.dbcp.dbcp.AbandonedConfig;
import org.apache.tomcat.dbcp.dbcp.AbandonedTrace;
import org.apache.tomcat.dbcp.pool.PoolableObjectFactory;
import org.apache.tomcat.dbcp.pool.impl.GenericObjectPool;

public class AbandonedObjectPool<T extends AbandonedTrace>
extends GenericObjectPool<T> {
    private final AbandonedConfig config;
    private final List<T> trace = new ArrayList<T>();

    public AbandonedObjectPool(PoolableObjectFactory<T> poolableObjectFactory, AbandonedConfig abandonedConfig) {
        super(poolableObjectFactory);
        this.config = abandonedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T borrowObject() throws Exception {
        AbandonedTrace abandonedTrace;
        if (this.config != null && this.config.getRemoveAbandoned() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxActive() - 3) {
            this.removeAbandoned();
        }
        if ((abandonedTrace = (AbandonedTrace)super.borrowObject()) != null) {
            abandonedTrace.setStackTrace();
        }
        if (abandonedTrace != null && this.config != null && this.config.getRemoveAbandoned()) {
            List<T> list = this.trace;
            synchronized (list) {
                this.trace.add(abandonedTrace);
            }
        }
        return (T)abandonedTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(T t) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List<T> list = this.trace;
            synchronized (list) {
                boolean bl = this.trace.remove(t);
                if (!bl) {
                    return;
                }
            }
        }
        super.returnObject(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(T t) throws Exception {
        if (this.config != null && this.config.getRemoveAbandoned()) {
            List<T> list = this.trace;
            synchronized (list) {
                boolean bl = this.trace.remove(t);
                if (!bl) {
                    return;
                }
            }
        }
        super.invalidateObject(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbandoned() {
        long l = System.currentTimeMillis();
        long l2 = l - (long)(this.config.getRemoveAbandonedTimeout() * 1000);
        ArrayList<AbandonedTrace> arrayList = new ArrayList<AbandonedTrace>();
        List<T> list = this.trace;
        synchronized (list) {
            for (AbandonedTrace abandonedTrace : this.trace) {
                if (abandonedTrace.getLastUsed() > l2 || abandonedTrace.getLastUsed() <= 0L) continue;
                arrayList.add(abandonedTrace);
            }
        }
        for (AbandonedTrace abandonedTrace : arrayList) {
            if (this.config.getLogAbandoned()) {
                abandonedTrace.printStackTrace();
            }
            try {
                this.invalidateObject((T)abandonedTrace);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

