/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.pool.ObjectPool;
import org.apache.tomcat.dbcp.pool.PoolableObjectFactory;

class CPDSConnectionFactory
implements PoolableObjectFactory<PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource _cpds;
    private final String _validationQuery;
    private final boolean _rollbackAfterValidation;
    private final ObjectPool<PooledConnectionAndInfo> _pool;
    private String _username = null;
    private String _password = null;
    private final Map<PooledConnection, Void> validatingMap = new HashMap<PooledConnection, Void>();
    private final WeakHashMap<PooledConnection, PooledConnectionAndInfo> pcMap = new WeakHashMap();

    public CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, ObjectPool<PooledConnectionAndInfo> objectPool, String string, String string2, String string3) {
        this(connectionPoolDataSource, objectPool, string, false, string2, string3);
    }

    public CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, ObjectPool<PooledConnectionAndInfo> objectPool, String string, boolean bl, String string2, String string3) {
        this._cpds = connectionPoolDataSource;
        this._pool = objectPool;
        objectPool.setFactory(this);
        this._validationQuery = string;
        this._username = string2;
        this._password = string3;
        this._rollbackAfterValidation = bl;
    }

    public ObjectPool<PooledConnectionAndInfo> getPool() {
        return this._pool;
    }

    @Override
    public synchronized PooledConnectionAndInfo makeObject() {
        PooledConnectionAndInfo pooledConnectionAndInfo;
        try {
            PooledConnection pooledConnection = null;
            pooledConnection = this._username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(this._username, this._password);
            if (pooledConnection == null) {
                throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
            }
            pooledConnection.addConnectionEventListener(this);
            pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, this._username, this._password);
            this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
        return pooledConnectionAndInfo;
    }

    @Override
    public void destroyObject(PooledConnectionAndInfo pooledConnectionAndInfo) throws Exception {
        PooledConnection pooledConnection = pooledConnectionAndInfo.getPooledConnection();
        pooledConnection.removeConnectionEventListener(this);
        this.pcMap.remove(pooledConnection);
        pooledConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validateObject(PooledConnectionAndInfo pooledConnectionAndInfo) {
        boolean bl = false;
        PooledConnection pooledConnection = pooledConnectionAndInfo.getPooledConnection();
        String string = this._validationQuery;
        if (null == string) return true;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        this.validatingMap.put(pooledConnection, null);
        try {
            connection = pooledConnection.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            bl = resultSet.next();
            if (!this._rollbackAfterValidation) return bl;
            connection.rollback();
            return bl;
        }
        catch (Exception exception) {
            bl = false;
            return bl;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
            this.validatingMap.remove(pooledConnection);
        }
    }

    @Override
    public void passivateObject(PooledConnectionAndInfo pooledConnectionAndInfo) {
    }

    @Override
    public void activateObject(PooledConnectionAndInfo pooledConnectionAndInfo) {
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingMap.containsKey(pooledConnection)) {
            PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
            if (pooledConnectionAndInfo == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(pooledConnectionAndInfo);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pooledConnection.removeConnectionEventListener(this);
                try {
                    this.destroyObject(pooledConnectionAndInfo);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
                    exception2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
            exception.printStackTrace();
        }
    }

    @Override
    public void invalidate(PooledConnection pooledConnection) throws SQLException {
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(pooledConnectionAndInfo);
            this._pool.close();
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error invalidating connection").initCause(exception);
        }
    }

    @Override
    public synchronized void setPassword(String string) {
        this._password = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePool(String string) throws SQLException {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (string == null || !string.equals(this._username)) {
                return;
            }
        }
        try {
            this._pool.close();
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error closing connection pool").initCause(exception);
        }
    }
}

