/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.CPDSConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.PerUserPoolDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.PoolKey;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool.ObjectPool;
import org.apache.tomcat.dbcp.pool.impl.GenericObjectPool;

public class PerUserPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = -3104731034410444060L;
    private int defaultMaxActive = 8;
    private int defaultMaxIdle = 8;
    private int defaultMaxWait = (int)Math.min(Integer.MAX_VALUE, -1L);
    Map<String, Boolean> perUserDefaultAutoCommit = null;
    Map<String, Integer> perUserDefaultTransactionIsolation = null;
    Map<String, Integer> perUserMaxActive = null;
    Map<String, Integer> perUserMaxIdle = null;
    Map<String, Integer> perUserMaxWait = null;
    Map<String, Boolean> perUserDefaultReadOnly = null;
    private transient Map<PoolKey, PooledConnectionManager> managers = new HashMap<PoolKey, PooledConnectionManager>();

    @Override
    public void close() {
        Iterator<PooledConnectionManager> iterator = this.managers.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((CPDSConnectionFactory)iterator.next()).getPool().close();
            }
            catch (Exception exception) {}
        }
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getDefaultMaxActive() {
        return this.defaultMaxActive;
    }

    public void setDefaultMaxActive(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxActive = n;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public void setDefaultMaxIdle(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = n;
    }

    public int getDefaultMaxWait() {
        return this.defaultMaxWait;
    }

    public void setDefaultMaxWait(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxWait = n;
    }

    public Boolean getPerUserDefaultAutoCommit(String string) {
        Boolean bl = null;
        if (this.perUserDefaultAutoCommit != null) {
            bl = this.perUserDefaultAutoCommit.get(string);
        }
        return bl;
    }

    public void setPerUserDefaultAutoCommit(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = new HashMap<String, Boolean>();
        }
        this.perUserDefaultAutoCommit.put(string, bl);
    }

    public Integer getPerUserDefaultTransactionIsolation(String string) {
        Integer n = null;
        if (this.perUserDefaultTransactionIsolation != null) {
            n = this.perUserDefaultTransactionIsolation.get(string);
        }
        return n;
    }

    public void setPerUserDefaultTransactionIsolation(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap<String, Integer>();
        }
        this.perUserDefaultTransactionIsolation.put(string, n);
    }

    public Integer getPerUserMaxActive(String string) {
        Integer n = null;
        if (this.perUserMaxActive != null) {
            n = this.perUserMaxActive.get(string);
        }
        return n;
    }

    public void setPerUserMaxActive(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserMaxActive == null) {
            this.perUserMaxActive = new HashMap<String, Integer>();
        }
        this.perUserMaxActive.put(string, n);
    }

    public Integer getPerUserMaxIdle(String string) {
        Integer n = null;
        if (this.perUserMaxIdle != null) {
            n = this.perUserMaxIdle.get(string);
        }
        return n;
    }

    public void setPerUserMaxIdle(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap<String, Integer>();
        }
        this.perUserMaxIdle.put(string, n);
    }

    public Integer getPerUserMaxWait(String string) {
        Integer n = null;
        if (this.perUserMaxWait != null) {
            n = this.perUserMaxWait.get(string);
        }
        return n;
    }

    public void setPerUserMaxWait(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWait == null) {
            this.perUserMaxWait = new HashMap<String, Integer>();
        }
        this.perUserMaxWait.put(string, n);
    }

    public Boolean getPerUserDefaultReadOnly(String string) {
        Boolean bl = null;
        if (this.perUserDefaultReadOnly != null) {
            bl = this.perUserDefaultReadOnly.get(string);
        }
        return bl;
    }

    public void setPerUserDefaultReadOnly(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = new HashMap<String, Boolean>();
        }
        this.perUserDefaultReadOnly.put(string, bl);
    }

    public int getNumActive() {
        return this.getNumActive(null, null);
    }

    public int getNumActive(String string, String string2) {
        ObjectPool<PooledConnectionAndInfo> objectPool = this.getPool(this.getPoolKey(string));
        return objectPool == null ? 0 : objectPool.getNumActive();
    }

    public int getNumIdle() {
        return this.getNumIdle(null, null);
    }

    public int getNumIdle(String string, String string2) {
        ObjectPool<PooledConnectionAndInfo> objectPool = this.getPool(this.getPoolKey(string));
        return objectPool == null ? 0 : objectPool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String string, String string2) throws SQLException {
        ObjectPool<PooledConnectionAndInfo> objectPool;
        PooledConnectionManager pooledConnectionManager;
        PoolKey poolKey = this.getPoolKey(string);
        Object object = this;
        synchronized (object) {
            pooledConnectionManager = this.managers.get(poolKey);
            if (pooledConnectionManager == null) {
                try {
                    this.registerPool(string, string2);
                    pooledConnectionManager = this.managers.get(poolKey);
                }
                catch (NamingException namingException) {
                    throw new SQLException("RegisterPool failed", namingException);
                }
            }
            objectPool = ((CPDSConnectionFactory)pooledConnectionManager).getPool();
        }
        object = null;
        try {
            object = objectPool.borrowObject();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Could not retrieve connection info from pool", noSuchElementException);
        }
        catch (Exception exception) {
            try {
                this.testCPDS(string, string2);
            }
            catch (Exception exception2) {
                throw (SQLException)new SQLException("Could not retrieve connection info from pool").initCause(exception2);
            }
            pooledConnectionManager.closePool(string);
            PerUserPoolDataSource perUserPoolDataSource = this;
            synchronized (perUserPoolDataSource) {
                this.managers.remove(poolKey);
            }
            try {
                this.registerPool(string, string2);
                objectPool = this.getPool(poolKey);
            }
            catch (NamingException namingException) {
                throw new SQLException("RegisterPool failed", namingException);
            }
            try {
                object = objectPool.borrowObject();
            }
            catch (Exception exception3) {
                throw (SQLException)new SQLException("Could not retrieve connection info from pool").initCause(exception3);
            }
        }
        return object;
    }

    @Override
    protected void setupDefaults(Connection connection, String string) throws SQLException {
        Integer n;
        Boolean bl;
        Boolean bl2;
        boolean bl3 = this.isDefaultAutoCommit();
        if (string != null && (bl2 = this.getPerUserDefaultAutoCommit(string)) != null) {
            bl3 = bl2;
        }
        boolean bl4 = this.isDefaultReadOnly();
        if (string != null && (bl = this.getPerUserDefaultReadOnly(string)) != null) {
            bl4 = bl;
        }
        int n2 = this.getDefaultTransactionIsolation();
        if (string != null && (n = this.getPerUserDefaultTransactionIsolation(string)) != null) {
            n2 = n;
        }
        if (connection.getAutoCommit() != bl3) {
            connection.setAutoCommit(bl3);
        }
        if (n2 != -1) {
            connection.setTransactionIsolation(n2);
        }
        if (connection.isReadOnly() != bl4) {
            connection.setReadOnly(bl4);
        }
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey userPassKey) {
        return this.managers.get(this.getPoolKey(userPassKey.getUsername()));
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), PerUserPoolDataSourceFactory.class.getName(), null);
        reference.add(new StringRefAddr("instanceKey", this.instanceKey));
        return reference;
    }

    private PoolKey getPoolKey(String string) {
        return new PoolKey(this.getDataSourceName(), string);
    }

    private synchronized void registerPool(String string, String string2) throws NamingException, SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = this.testCPDS(string, string2);
        Integer n = this.getPerUserMaxActive(string);
        int n2 = n == null ? this.getDefaultMaxActive() : n.intValue();
        n = this.getPerUserMaxIdle(string);
        int n3 = n == null ? this.getDefaultMaxIdle() : n.intValue();
        n = this.getPerUserMaxWait(string);
        int n4 = n == null ? this.getDefaultMaxWait() : n.intValue();
        GenericObjectPool<PooledConnectionAndInfo> genericObjectPool = new GenericObjectPool<PooledConnectionAndInfo>(null);
        genericObjectPool.setMaxActive(n2);
        genericObjectPool.setMaxIdle(n3);
        genericObjectPool.setMaxWait(n4);
        genericObjectPool.setWhenExhaustedAction(this.whenExhaustedAction(n2, n4));
        genericObjectPool.setTestOnBorrow(this.getTestOnBorrow());
        genericObjectPool.setTestOnReturn(this.getTestOnReturn());
        genericObjectPool.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        genericObjectPool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        genericObjectPool.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        genericObjectPool.setTestWhileIdle(this.getTestWhileIdle());
        CPDSConnectionFactory cPDSConnectionFactory = new CPDSConnectionFactory(connectionPoolDataSource, genericObjectPool, this.getValidationQuery(), this.isRollbackAfterValidation(), string, string2);
        PooledConnectionManager pooledConnectionManager = this.managers.put(this.getPoolKey(string), cPDSConnectionFactory);
        if (pooledConnectionManager != null) {
            throw new IllegalStateException("Pool already contains an entry for this user/password: " + string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
            PerUserPoolDataSource perUserPoolDataSource = (PerUserPoolDataSource)new PerUserPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.managers = perUserPoolDataSource.managers;
        }
        catch (NamingException namingException) {
            throw new IOException("NamingException: " + namingException);
        }
    }

    private ObjectPool<PooledConnectionAndInfo> getPool(PoolKey poolKey) {
        CPDSConnectionFactory cPDSConnectionFactory = (CPDSConnectionFactory)this.managers.get(poolKey);
        return cPDSConnectionFactory == null ? null : cPDSConnectionFactory.getPool();
    }
}

