/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedPoolableObjectFactory;
import org.apache.tomcat.dbcp.pool.ObjectPool;
import org.apache.tomcat.dbcp.pool.PoolableObjectFactory;

public final class PoolUtils {
    private static Timer MIN_IDLE_TIMER;

    public static void checkRethrow(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    public static <V> PoolableObjectFactory<V> adapt(KeyedPoolableObjectFactory<Object, V> keyedPoolableObjectFactory) throws IllegalArgumentException {
        return PoolUtils.adapt(keyedPoolableObjectFactory, new Object());
    }

    public static <K, V> PoolableObjectFactory<V> adapt(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, K k) throws IllegalArgumentException {
        return new PoolableObjectFactoryAdaptor<K, V>(keyedPoolableObjectFactory, k);
    }

    public static <K, V> KeyedPoolableObjectFactory<K, V> adapt(PoolableObjectFactory<V> poolableObjectFactory) throws IllegalArgumentException {
        return new KeyedPoolableObjectFactoryAdaptor(poolableObjectFactory);
    }

    public static <V> ObjectPool<V> adapt(KeyedObjectPool<Object, V> keyedObjectPool) throws IllegalArgumentException {
        return PoolUtils.adapt(keyedObjectPool, new Object());
    }

    public static <V> ObjectPool<V> adapt(KeyedObjectPool<Object, V> keyedObjectPool, Object object) throws IllegalArgumentException {
        return new ObjectPoolAdaptor<V>(keyedObjectPool, object);
    }

    public static <K, V> KeyedObjectPool<K, V> adapt(ObjectPool<V> objectPool) throws IllegalArgumentException {
        return new KeyedObjectPoolAdaptor(objectPool);
    }

    public static <T> ObjectPool<T> checkedPool(ObjectPool<T> objectPool, Class<T> clazz) {
        if (objectPool == null) {
            throw new IllegalArgumentException("pool must not be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        return new CheckedObjectPool<T>(objectPool, clazz);
    }

    public static <K, V> KeyedObjectPool<K, V> checkedPool(KeyedObjectPool<K, V> keyedObjectPool, Class<V> clazz) {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        return new CheckedKeyedObjectPool<K, V>(keyedObjectPool, clazz);
    }

    public static <T> TimerTask checkMinIdle(ObjectPool<T> objectPool, int n, long l) throws IllegalArgumentException {
        if (objectPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("minIdle must be non-negative.");
        }
        ObjectPoolMinIdleTimerTask<T> objectPoolMinIdleTimerTask = new ObjectPoolMinIdleTimerTask<T>(objectPool, n);
        PoolUtils.getMinIdleTimer().schedule(objectPoolMinIdleTimerTask, 0L, l);
        return objectPoolMinIdleTimerTask;
    }

    public static <K, V> TimerTask checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, K k, int n, long l) throws IllegalArgumentException {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (k == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("minIdle must be non-negative.");
        }
        KeyedObjectPoolMinIdleTimerTask<K, V> keyedObjectPoolMinIdleTimerTask = new KeyedObjectPoolMinIdleTimerTask<K, V>(keyedObjectPool, k, n);
        PoolUtils.getMinIdleTimer().schedule(keyedObjectPoolMinIdleTimerTask, 0L, l);
        return keyedObjectPoolMinIdleTimerTask;
    }

    public static <K, V> Map<K, TimerTask> checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, Collection<? extends K> collection, int n, long l) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("keys must not be null.");
        }
        HashMap<K, TimerTask> hashMap = new HashMap<K, TimerTask>(collection.size());
        for (K k : collection) {
            TimerTask timerTask = PoolUtils.checkMinIdle(keyedObjectPool, k, n, l);
            hashMap.put(k, timerTask);
        }
        return hashMap;
    }

    public static <T> void prefill(ObjectPool<T> objectPool, int n) throws Exception, IllegalArgumentException {
        if (objectPool == null) {
            throw new IllegalArgumentException("pool must not be null.");
        }
        for (int i = 0; i < n; ++i) {
            objectPool.addObject();
        }
    }

    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, K k, int n) throws Exception, IllegalArgumentException {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (k == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        for (int i = 0; i < n; ++i) {
            keyedObjectPool.addObject(k);
        }
    }

    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, Collection<? extends K> collection, int n) throws Exception, IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("keys must not be null.");
        }
        Iterator<K> iterator = collection.iterator();
        while (iterator.hasNext()) {
            PoolUtils.prefill(keyedObjectPool, iterator.next(), n);
        }
    }

    public static <T> ObjectPool<T> synchronizedPool(ObjectPool<T> objectPool) {
        if (objectPool == null) {
            throw new IllegalArgumentException("pool must not be null.");
        }
        return new SynchronizedObjectPool<T>(objectPool);
    }

    public static <K, V> KeyedObjectPool<K, V> synchronizedPool(KeyedObjectPool<K, V> keyedObjectPool) {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        return new SynchronizedKeyedObjectPool<K, V>(keyedObjectPool);
    }

    public static <T> PoolableObjectFactory<T> synchronizedPoolableFactory(PoolableObjectFactory<T> poolableObjectFactory) {
        return new SynchronizedPoolableObjectFactory<T>(poolableObjectFactory);
    }

    public static <K, V> KeyedPoolableObjectFactory<K, V> synchronizedPoolableFactory(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) {
        return new SynchronizedKeyedPoolableObjectFactory<K, V>(keyedPoolableObjectFactory);
    }

    public static <T> ObjectPool<T> erodingPool(ObjectPool<T> objectPool) {
        return PoolUtils.erodingPool(objectPool, 1.0f);
    }

    public static <T> ObjectPool<T> erodingPool(ObjectPool<T> objectPool, float f) {
        if (objectPool == null) {
            throw new IllegalArgumentException("pool must not be null.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("factor must be positive.");
        }
        return new ErodingObjectPool<T>(objectPool, f);
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool) {
        return PoolUtils.erodingPool(keyedObjectPool, 1.0f);
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool, float f) {
        return PoolUtils.erodingPool(keyedObjectPool, f, false);
    }

    public static <K, V> KeyedObjectPool<K, V> erodingPool(KeyedObjectPool<K, V> keyedObjectPool, float f, boolean bl) {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException("keyedPool must not be null.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("factor must be positive.");
        }
        if (bl) {
            return new ErodingPerKeyKeyedObjectPool<K, V>(keyedObjectPool, f);
        }
        return new ErodingKeyedObjectPool<K, V>(keyedObjectPool, f);
    }

    private static synchronized Timer getMinIdleTimer() {
        if (MIN_IDLE_TIMER == null) {
            MIN_IDLE_TIMER = new Timer(true);
        }
        return MIN_IDLE_TIMER;
    }

    private static class ErodingPerKeyKeyedObjectPool<K, V>
    extends ErodingKeyedObjectPool<K, V> {
        private final float factor;
        private final Map<K, ErodingFactor> factors = Collections.synchronizedMap(new HashMap());

        public ErodingPerKeyKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, float f) {
            super(keyedObjectPool, null);
            this.factor = f;
        }

        @Override
        protected int numIdle(K k) {
            return this.getKeyedPool().getNumIdle(k);
        }

        @Override
        protected ErodingFactor getErodingFactor(K k) {
            ErodingFactor erodingFactor = this.factors.get(k);
            if (erodingFactor == null) {
                erodingFactor = new ErodingFactor(this.factor);
                this.factors.put(k, erodingFactor);
            }
            return erodingFactor;
        }

        @Override
        public String toString() {
            return "ErodingPerKeyKeyedObjectPool{factor=" + this.factor + ", keyedPool=" + this.getKeyedPool() + '}';
        }
    }

    private static class ErodingKeyedObjectPool<K, V>
    implements KeyedObjectPool<K, V> {
        private final KeyedObjectPool<K, V> keyedPool;
        private final ErodingFactor erodingFactor;

        public ErodingKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, float f) {
            this(keyedObjectPool, new ErodingFactor(f));
        }

        protected ErodingKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, ErodingFactor erodingFactor) {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.keyedPool = keyedObjectPool;
            this.erodingFactor = erodingFactor;
        }

        @Override
        public V borrowObject(K k) throws Exception, NoSuchElementException, IllegalStateException {
            return this.keyedPool.borrowObject(k);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(K k, V v) throws Exception {
            boolean bl = false;
            long l = System.currentTimeMillis();
            ErodingFactor erodingFactor = this.getErodingFactor(k);
            KeyedObjectPool<K, V> keyedObjectPool = this.keyedPool;
            synchronized (keyedObjectPool) {
                if (erodingFactor.getNextShrink() < l) {
                    int n = this.numIdle(k);
                    if (n > 0) {
                        bl = true;
                    }
                    erodingFactor.update(l, n);
                }
            }
            try {
                if (bl) {
                    this.keyedPool.invalidateObject(k, v);
                } else {
                    this.keyedPool.returnObject(k, v);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected int numIdle(K k) {
            return this.getKeyedPool().getNumIdle();
        }

        protected ErodingFactor getErodingFactor(K k) {
            return this.erodingFactor;
        }

        @Override
        public void invalidateObject(K k, V v) {
            try {
                this.keyedPool.invalidateObject(k, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void addObject(K k) throws Exception, IllegalStateException, UnsupportedOperationException {
            this.keyedPool.addObject(k);
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle();
        }

        @Override
        public int getNumIdle(K k) throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle(k);
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.keyedPool.getNumActive();
        }

        @Override
        public int getNumActive(K k) throws UnsupportedOperationException {
            return this.keyedPool.getNumActive(k);
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            this.keyedPool.clear();
        }

        @Override
        public void clear(K k) throws Exception, UnsupportedOperationException {
            this.keyedPool.clear(k);
        }

        @Override
        public void close() {
            try {
                this.keyedPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        @Deprecated
        public void setFactory(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) throws IllegalStateException, UnsupportedOperationException {
            this.keyedPool.setFactory(keyedPoolableObjectFactory);
        }

        protected KeyedObjectPool<K, V> getKeyedPool() {
            return this.keyedPool;
        }

        public String toString() {
            return "ErodingKeyedObjectPool{erodingFactor=" + this.erodingFactor + ", keyedPool=" + this.keyedPool + '}';
        }
    }

    private static class ErodingObjectPool<T>
    implements ObjectPool<T> {
        private final ObjectPool<T> pool;
        private final ErodingFactor factor;

        public ErodingObjectPool(ObjectPool<T> objectPool, float f) {
            this.pool = objectPool;
            this.factor = new ErodingFactor(f);
        }

        @Override
        public T borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
            return this.pool.borrowObject();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(T t) {
            boolean bl = false;
            long l = System.currentTimeMillis();
            ObjectPool<T> objectPool = this.pool;
            synchronized (objectPool) {
                if (this.factor.getNextShrink() < l) {
                    int n = this.pool.getNumIdle();
                    if (n > 0) {
                        bl = true;
                    }
                    this.factor.update(l, n);
                }
            }
            try {
                if (bl) {
                    this.pool.invalidateObject(t);
                } else {
                    this.pool.returnObject(t);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void invalidateObject(T t) {
            try {
                this.pool.invalidateObject(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
            this.pool.addObject();
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            this.pool.clear();
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        @Deprecated
        public void setFactory(PoolableObjectFactory<T> poolableObjectFactory) throws IllegalStateException, UnsupportedOperationException {
            this.pool.setFactory(poolableObjectFactory);
        }

        public String toString() {
            return "ErodingObjectPool{factor=" + this.factor + ", pool=" + this.pool + '}';
        }
    }

    private static class ErodingFactor {
        private final float factor;
        private volatile transient long nextShrink;
        private volatile transient int idleHighWaterMark;

        public ErodingFactor(float f) {
            this.factor = f;
            this.nextShrink = System.currentTimeMillis() + (long)(900000.0f * f);
            this.idleHighWaterMark = 1;
        }

        public void update(long l, int n) {
            int n2 = Math.max(0, n);
            this.idleHighWaterMark = Math.max(n2, this.idleHighWaterMark);
            float f = 15.0f + -14.0f / (float)this.idleHighWaterMark * (float)n2;
            this.nextShrink = l + (long)(f * 60000.0f * this.factor);
        }

        public long getNextShrink() {
            return this.nextShrink;
        }

        public String toString() {
            return "ErodingFactor{factor=" + this.factor + ", idleHighWaterMark=" + this.idleHighWaterMark + '}';
        }
    }

    private static class SynchronizedKeyedPoolableObjectFactory<K, V>
    implements KeyedPoolableObjectFactory<K, V> {
        private final Object lock;
        private final KeyedPoolableObjectFactory<K, V> keyedFactory;

        SynchronizedKeyedPoolableObjectFactory(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) throws IllegalArgumentException {
            if (keyedPoolableObjectFactory == null) {
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            this.keyedFactory = keyedPoolableObjectFactory;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V makeObject(K k) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedFactory.makeObject(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroyObject(K k, V v) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.keyedFactory.destroyObject(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateObject(K k, V v) {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedFactory.validateObject(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void activateObject(K k, V v) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.keyedFactory.activateObject(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void passivateObject(K k, V v) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.keyedFactory.passivateObject(k, v);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SynchronizedKeyedPoolableObjectFactory");
            stringBuffer.append("{keyedFactory=").append(this.keyedFactory);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class SynchronizedPoolableObjectFactory<T>
    implements PoolableObjectFactory<T> {
        private final Object lock;
        private final PoolableObjectFactory<T> factory;

        SynchronizedPoolableObjectFactory(PoolableObjectFactory<T> poolableObjectFactory) throws IllegalArgumentException {
            if (poolableObjectFactory == null) {
                throw new IllegalArgumentException("factory must not be null.");
            }
            this.factory = poolableObjectFactory;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T makeObject() throws Exception {
            Object object = this.lock;
            synchronized (object) {
                return this.factory.makeObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroyObject(T t) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.factory.destroyObject(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateObject(T t) {
            Object object = this.lock;
            synchronized (object) {
                return this.factory.validateObject(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void activateObject(T t) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.factory.activateObject(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void passivateObject(T t) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.factory.passivateObject(t);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SynchronizedPoolableObjectFactory");
            stringBuffer.append("{factory=").append(this.factory);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class SynchronizedKeyedObjectPool<K, V>
    implements KeyedObjectPool<K, V> {
        private final Object lock;
        private final KeyedObjectPool<K, V> keyedPool;

        SynchronizedKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool) throws IllegalArgumentException {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.keyedPool = keyedObjectPool;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V borrowObject(K k) throws Exception, NoSuchElementException, IllegalStateException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.borrowObject(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(K k, V v) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.keyedPool.returnObject(k, v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateObject(K k, V v) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.keyedPool.invalidateObject(k, v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addObject(K k) throws Exception, IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.addObject(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumIdle(K k) throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumIdle(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumActive(K k) throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumActive(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumActive() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.keyedPool.getNumActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear(K k) throws Exception, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.clear(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.keyedPool.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void setFactory(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) throws IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.keyedPool.setFactory(keyedPoolableObjectFactory);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SynchronizedKeyedObjectPool");
            stringBuffer.append("{keyedPool=").append(this.keyedPool);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class SynchronizedObjectPool<T>
    implements ObjectPool<T> {
        private final Object lock;
        private final ObjectPool<T> pool;

        SynchronizedObjectPool(ObjectPool<T> objectPool) throws IllegalArgumentException {
            if (objectPool == null) {
                throw new IllegalArgumentException("pool must not be null.");
            }
            this.pool = objectPool;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
            Object object = this.lock;
            synchronized (object) {
                return this.pool.borrowObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void returnObject(T t) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.pool.returnObject(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateObject(T t) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.pool.invalidateObject(t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.pool.addObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.pool.getNumIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNumActive() throws UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                return this.pool.getNumActive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.pool.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.pool.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void setFactory(PoolableObjectFactory<T> poolableObjectFactory) throws IllegalStateException, UnsupportedOperationException {
            Object object = this.lock;
            synchronized (object) {
                this.pool.setFactory(poolableObjectFactory);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SynchronizedObjectPool");
            stringBuffer.append("{pool=").append(this.pool);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class KeyedObjectPoolMinIdleTimerTask<K, V>
    extends TimerTask {
        private final int minIdle;
        private final K key;
        private final KeyedObjectPool<K, V> keyedPool;

        KeyedObjectPoolMinIdleTimerTask(KeyedObjectPool<K, V> keyedObjectPool, K k, int n) throws IllegalArgumentException {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            this.keyedPool = keyedObjectPool;
            this.key = k;
            this.minIdle = n;
        }

        @Override
        public void run() {
            boolean bl = false;
            try {
                if (this.keyedPool.getNumIdle(this.key) < this.minIdle) {
                    this.keyedPool.addObject(this.key);
                }
                bl = true;
            }
            catch (Exception exception) {
                this.cancel();
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("KeyedObjectPoolMinIdleTimerTask");
            stringBuffer.append("{minIdle=").append(this.minIdle);
            stringBuffer.append(", key=").append(this.key);
            stringBuffer.append(", keyedPool=").append(this.keyedPool);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class ObjectPoolMinIdleTimerTask<T>
    extends TimerTask {
        private final int minIdle;
        private final ObjectPool<T> pool;

        ObjectPoolMinIdleTimerTask(ObjectPool<T> objectPool, int n) throws IllegalArgumentException {
            if (objectPool == null) {
                throw new IllegalArgumentException("pool must not be null.");
            }
            this.pool = objectPool;
            this.minIdle = n;
        }

        @Override
        public void run() {
            boolean bl = false;
            try {
                if (this.pool.getNumIdle() < this.minIdle) {
                    this.pool.addObject();
                }
                bl = true;
            }
            catch (Exception exception) {
                this.cancel();
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ObjectPoolMinIdleTimerTask");
            stringBuffer.append("{minIdle=").append(this.minIdle);
            stringBuffer.append(", pool=").append(this.pool);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class CheckedKeyedObjectPool<K, V>
    implements KeyedObjectPool<K, V> {
        private final Class<V> type;
        private final KeyedObjectPool<K, V> keyedPool;

        CheckedKeyedObjectPool(KeyedObjectPool<K, V> keyedObjectPool, Class<V> clazz) {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            if (clazz == null) {
                throw new IllegalArgumentException("type must not be null.");
            }
            this.keyedPool = keyedObjectPool;
            this.type = clazz;
        }

        @Override
        public V borrowObject(K k) throws Exception, NoSuchElementException, IllegalStateException {
            V v = this.keyedPool.borrowObject(k);
            if (this.type.isInstance(v)) {
                return v;
            }
            throw new ClassCastException("Borrowed object for key: " + k + " is not of type: " + this.type.getName() + " was: " + v);
        }

        @Override
        public void returnObject(K k, V v) {
            if (this.type.isInstance(v)) {
                try {
                    this.keyedPool.returnObject(k, v);
                }
                catch (Exception exception) {}
            } else {
                throw new ClassCastException("Returned object for key: " + k + " is not of type: " + this.type.getName() + " was: " + v);
            }
        }

        @Override
        public void invalidateObject(K k, V v) {
            if (this.type.isInstance(v)) {
                try {
                    this.keyedPool.invalidateObject(k, v);
                }
                catch (Exception exception) {}
            } else {
                throw new ClassCastException("Invalidated object for key: " + k + " is not of type: " + this.type.getName() + " was: " + v);
            }
        }

        @Override
        public void addObject(K k) throws Exception, IllegalStateException, UnsupportedOperationException {
            this.keyedPool.addObject(k);
        }

        @Override
        public int getNumIdle(K k) throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle(k);
        }

        @Override
        public int getNumActive(K k) throws UnsupportedOperationException {
            return this.keyedPool.getNumActive(k);
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle();
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.keyedPool.getNumActive();
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            this.keyedPool.clear();
        }

        @Override
        public void clear(K k) throws Exception, UnsupportedOperationException {
            this.keyedPool.clear(k);
        }

        @Override
        public void close() {
            try {
                this.keyedPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        @Deprecated
        public void setFactory(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) throws IllegalStateException, UnsupportedOperationException {
            this.keyedPool.setFactory(keyedPoolableObjectFactory);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CheckedKeyedObjectPool");
            stringBuffer.append("{type=").append(this.type);
            stringBuffer.append(", keyedPool=").append(this.keyedPool);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class CheckedObjectPool<T>
    implements ObjectPool<T> {
        private final Class<T> type;
        private final ObjectPool<T> pool;

        CheckedObjectPool(ObjectPool<T> objectPool, Class<T> clazz) {
            if (objectPool == null) {
                throw new IllegalArgumentException("pool must not be null.");
            }
            if (clazz == null) {
                throw new IllegalArgumentException("type must not be null.");
            }
            this.pool = objectPool;
            this.type = clazz;
        }

        @Override
        public T borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
            T t = this.pool.borrowObject();
            if (this.type.isInstance(t)) {
                return t;
            }
            throw new ClassCastException("Borrowed object is not of type: " + this.type.getName() + " was: " + t);
        }

        @Override
        public void returnObject(T t) {
            if (this.type.isInstance(t)) {
                try {
                    this.pool.returnObject(t);
                }
                catch (Exception exception) {}
            } else {
                throw new ClassCastException("Returned object is not of type: " + this.type.getName() + " was: " + t);
            }
        }

        @Override
        public void invalidateObject(T t) {
            if (this.type.isInstance(t)) {
                try {
                    this.pool.invalidateObject(t);
                }
                catch (Exception exception) {}
            } else {
                throw new ClassCastException("Invalidated object is not of type: " + this.type.getName() + " was: " + t);
            }
        }

        @Override
        public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
            this.pool.addObject();
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            this.pool.clear();
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        @Deprecated
        public void setFactory(PoolableObjectFactory<T> poolableObjectFactory) throws IllegalStateException, UnsupportedOperationException {
            this.pool.setFactory(poolableObjectFactory);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CheckedObjectPool");
            stringBuffer.append("{type=").append(this.type);
            stringBuffer.append(", pool=").append(this.pool);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class KeyedObjectPoolAdaptor<K, V>
    implements KeyedObjectPool<K, V> {
        private final ObjectPool<V> pool;

        KeyedObjectPoolAdaptor(ObjectPool<V> objectPool) throws IllegalArgumentException {
            if (objectPool == null) {
                throw new IllegalArgumentException("pool must not be null.");
            }
            this.pool = objectPool;
        }

        @Override
        public V borrowObject(K k) throws Exception, NoSuchElementException, IllegalStateException {
            return this.pool.borrowObject();
        }

        @Override
        public void returnObject(K k, V v) {
            try {
                this.pool.returnObject(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void invalidateObject(K k, V v) {
            try {
                this.pool.invalidateObject(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void addObject(K k) throws Exception, IllegalStateException {
            this.pool.addObject();
        }

        @Override
        public int getNumIdle(K k) throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        @Override
        public int getNumActive(K k) throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.pool.getNumIdle();
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.pool.getNumActive();
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            this.pool.clear();
        }

        @Override
        public void clear(K k) throws Exception, UnsupportedOperationException {
            this.pool.clear();
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        @Deprecated
        public void setFactory(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) throws IllegalStateException, UnsupportedOperationException {
            this.pool.setFactory(PoolUtils.adapt(keyedPoolableObjectFactory));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("KeyedObjectPoolAdaptor");
            stringBuffer.append("{pool=").append(this.pool);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class ObjectPoolAdaptor<V>
    implements ObjectPool<V> {
        private final Object key;
        private final KeyedObjectPool<Object, V> keyedPool;

        ObjectPoolAdaptor(KeyedObjectPool<Object, V> keyedObjectPool, Object object) throws IllegalArgumentException {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException("keyedPool must not be null.");
            }
            if (object == null) {
                throw new IllegalArgumentException("key must not be null.");
            }
            this.keyedPool = keyedObjectPool;
            this.key = object;
        }

        @Override
        public V borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
            return this.keyedPool.borrowObject(this.key);
        }

        @Override
        public void returnObject(V v) {
            try {
                this.keyedPool.returnObject(this.key, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void invalidateObject(V v) {
            try {
                this.keyedPool.invalidateObject(this.key, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void addObject() throws Exception, IllegalStateException {
            this.keyedPool.addObject(this.key);
        }

        @Override
        public int getNumIdle() throws UnsupportedOperationException {
            return this.keyedPool.getNumIdle(this.key);
        }

        @Override
        public int getNumActive() throws UnsupportedOperationException {
            return this.keyedPool.getNumActive(this.key);
        }

        @Override
        public void clear() throws Exception, UnsupportedOperationException {
            this.keyedPool.clear();
        }

        @Override
        public void close() {
            try {
                this.keyedPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        @Deprecated
        public void setFactory(PoolableObjectFactory<V> poolableObjectFactory) throws IllegalStateException, UnsupportedOperationException {
            this.keyedPool.setFactory(PoolUtils.adapt(poolableObjectFactory));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ObjectPoolAdaptor");
            stringBuffer.append("{key=").append(this.key);
            stringBuffer.append(", keyedPool=").append(this.keyedPool);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class KeyedPoolableObjectFactoryAdaptor<K, V>
    implements KeyedPoolableObjectFactory<K, V> {
        private final PoolableObjectFactory<V> factory;

        KeyedPoolableObjectFactoryAdaptor(PoolableObjectFactory<V> poolableObjectFactory) throws IllegalArgumentException {
            if (poolableObjectFactory == null) {
                throw new IllegalArgumentException("factory must not be null.");
            }
            this.factory = poolableObjectFactory;
        }

        @Override
        public V makeObject(K k) throws Exception {
            return this.factory.makeObject();
        }

        @Override
        public void destroyObject(K k, V v) throws Exception {
            this.factory.destroyObject(v);
        }

        @Override
        public boolean validateObject(K k, V v) {
            return this.factory.validateObject(v);
        }

        @Override
        public void activateObject(K k, V v) throws Exception {
            this.factory.activateObject(v);
        }

        @Override
        public void passivateObject(K k, V v) throws Exception {
            this.factory.passivateObject(v);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("KeyedPoolableObjectFactoryAdaptor");
            stringBuffer.append("{factory=").append(this.factory);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class PoolableObjectFactoryAdaptor<K, V>
    implements PoolableObjectFactory<V> {
        private final K key;
        private final KeyedPoolableObjectFactory<K, V> keyedFactory;

        PoolableObjectFactoryAdaptor(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, K k) throws IllegalArgumentException {
            if (keyedPoolableObjectFactory == null) {
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            if (k == null) {
                throw new IllegalArgumentException("key must not be null.");
            }
            this.keyedFactory = keyedPoolableObjectFactory;
            this.key = k;
        }

        @Override
        public V makeObject() throws Exception {
            return this.keyedFactory.makeObject(this.key);
        }

        @Override
        public void destroyObject(V v) throws Exception {
            this.keyedFactory.destroyObject(this.key, v);
        }

        @Override
        public boolean validateObject(V v) {
            return this.keyedFactory.validateObject(this.key, v);
        }

        @Override
        public void activateObject(V v) throws Exception {
            this.keyedFactory.activateObject(this.key, v);
        }

        @Override
        public void passivateObject(V v) throws Exception {
            this.keyedFactory.passivateObject(this.key, v);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PoolableObjectFactoryAdaptor");
            stringBuffer.append("{key=").append(this.key);
            stringBuffer.append(", keyedFactory=").append(this.keyedFactory);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }
}

