/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceLink;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;

public class NamingResourcesMBean
extends BaseModelMBean {
    protected final Registry registry = MBeanUtils.createRegistry();
    protected final ManagedBean managed = this.registry.findManagedBean("NamingResources");

    public String[] getEnvironments() {
        ContextEnvironment[] contextEnvironmentArray = ((NamingResourcesImpl)this.resource).findEnvironments();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ContextEnvironment contextEnvironment : contextEnvironmentArray) {
            try {
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), contextEnvironment);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for environment " + contextEnvironment);
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getResources() {
        ContextResource[] contextResourceArray = ((NamingResourcesImpl)this.resource).findResources();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ContextResource contextResource : contextResourceArray) {
            try {
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), contextResource);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for resource " + contextResource);
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getResourceLinks() {
        ContextResourceLink[] contextResourceLinkArray = ((NamingResourcesImpl)this.resource).findResourceLinks();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ContextResourceLink contextResourceLink : contextResourceLinkArray) {
            try {
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), contextResourceLink);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for resource " + contextResourceLink);
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String addEnvironment(String string, String string2, String string3) throws MalformedObjectNameException {
        NamingResourcesImpl namingResourcesImpl = (NamingResourcesImpl)this.resource;
        if (namingResourcesImpl == null) {
            return null;
        }
        ContextEnvironment contextEnvironment = namingResourcesImpl.findEnvironment(string);
        if (contextEnvironment != null) {
            throw new IllegalArgumentException("Invalid environment name - already exists '" + string + "'");
        }
        contextEnvironment = new ContextEnvironment();
        contextEnvironment.setName(string);
        contextEnvironment.setType(string2);
        contextEnvironment.setValue(string3);
        namingResourcesImpl.addEnvironment(contextEnvironment);
        ManagedBean managedBean = this.registry.findManagedBean("ContextEnvironment");
        ObjectName objectName = MBeanUtils.createObjectName(managedBean.getDomain(), contextEnvironment);
        return objectName.toString();
    }

    public String addResource(String string, String string2) throws MalformedObjectNameException {
        NamingResourcesImpl namingResourcesImpl = (NamingResourcesImpl)this.resource;
        if (namingResourcesImpl == null) {
            return null;
        }
        ContextResource contextResource = namingResourcesImpl.findResource(string);
        if (contextResource != null) {
            throw new IllegalArgumentException("Invalid resource name - already exists'" + string + "'");
        }
        contextResource = new ContextResource();
        contextResource.setName(string);
        contextResource.setType(string2);
        namingResourcesImpl.addResource(contextResource);
        ManagedBean managedBean = this.registry.findManagedBean("ContextResource");
        ObjectName objectName = MBeanUtils.createObjectName(managedBean.getDomain(), contextResource);
        return objectName.toString();
    }

    public String addResourceLink(String string, String string2) throws MalformedObjectNameException {
        NamingResourcesImpl namingResourcesImpl = (NamingResourcesImpl)this.resource;
        if (namingResourcesImpl == null) {
            return null;
        }
        ContextResourceLink contextResourceLink = namingResourcesImpl.findResourceLink(string);
        if (contextResourceLink != null) {
            throw new IllegalArgumentException("Invalid resource link name - already exists'" + string + "'");
        }
        contextResourceLink = new ContextResourceLink();
        contextResourceLink.setName(string);
        contextResourceLink.setType(string2);
        namingResourcesImpl.addResourceLink(contextResourceLink);
        ManagedBean managedBean = this.registry.findManagedBean("ContextResourceLink");
        ObjectName objectName = MBeanUtils.createObjectName(managedBean.getDomain(), contextResourceLink);
        return objectName.toString();
    }

    public void removeEnvironment(String string) {
        NamingResourcesImpl namingResourcesImpl = (NamingResourcesImpl)this.resource;
        if (namingResourcesImpl == null) {
            return;
        }
        ContextEnvironment contextEnvironment = namingResourcesImpl.findEnvironment(string);
        if (contextEnvironment == null) {
            throw new IllegalArgumentException("Invalid environment name '" + string + "'");
        }
        namingResourcesImpl.removeEnvironment(string);
    }

    public void removeResource(String string) {
        string = ObjectName.unquote(string);
        NamingResourcesImpl namingResourcesImpl = (NamingResourcesImpl)this.resource;
        if (namingResourcesImpl == null) {
            return;
        }
        ContextResource contextResource = namingResourcesImpl.findResource(string);
        if (contextResource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + string + "'");
        }
        namingResourcesImpl.removeResource(string);
    }

    public void removeResourceLink(String string) {
        string = ObjectName.unquote(string);
        NamingResourcesImpl namingResourcesImpl = (NamingResourcesImpl)this.resource;
        if (namingResourcesImpl == null) {
            return;
        }
        ContextResourceLink contextResourceLink = namingResourcesImpl.findResourceLink(string);
        if (contextResourceLink == null) {
            throw new IllegalArgumentException("Invalid resource Link name '" + string + "'");
        }
        namingResourcesImpl.removeResourceLink(string);
    }
}

