/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.util.Deque;
import java.util.jar.JarFile;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.tomcat.util.compat.Jre8Compat;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final int RUNTIME_MAJOR_VERSION = 7;
    private static final JreCompat instance;
    private static StringManager sm;
    private static final boolean jre9Available;
    private static final boolean jre8Available;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isJre8Available() {
        return jre8Available;
    }

    public void setUseServerCipherSuitesOrder(SSLParameters sSLParameters, boolean bl) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    public KeyStore.LoadStoreParameter getDomainLoadStoreParameter(URI uRI) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noDomainLoadStoreParameter"));
    }

    public static boolean isAlpnSupported() {
        return JreCompat.isJre9Available() || JreCompat.isJre8Available() && Jre8Compat.isAlpnSupported();
    }

    public static boolean isJre9Available() {
        return jre9Available;
    }

    public boolean isInstanceOfInaccessibleObjectException(Throwable throwable) {
        return false;
    }

    public void setApplicationProtocols(SSLParameters sSLParameters, String[] stringArray) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noApplicationProtocols"));
    }

    public String getApplicationProtocol(SSLEngine sSLEngine) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noApplicationProtocol"));
    }

    public void disableCachingForJarUrlConnections() throws IOException {
        URL uRL = new URL("jar:file://dummy.jar!/");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDefaultUseCaches(false);
    }

    public void addBootModulePath(Deque<URL> deque) {
    }

    public final JarFile jarFileNewInstance(String string) throws IOException {
        return this.jarFileNewInstance(new File(string));
    }

    public JarFile jarFileNewInstance(File file) throws IOException {
        return new JarFile(file);
    }

    public boolean jarFileIsMultiRelease(JarFile jarFile) {
        return false;
    }

    public int jarFileRuntimeMajorVersion() {
        return 7;
    }

    public boolean canAccess(Object object, AccessibleObject accessibleObject) {
        return true;
    }

    public boolean isExported(Class<?> clazz) {
        return true;
    }

    public String getModuleName(Class<?> clazz) {
        return "NO_MODULE_JAVA_8";
    }

    static {
        sm = StringManager.getManager(JreCompat.class.getPackage().getName());
        if (Jre9Compat.isSupported()) {
            instance = new Jre9Compat();
            jre9Available = true;
            jre8Available = true;
        } else if (Jre8Compat.isSupported()) {
            instance = new Jre8Compat();
            jre9Available = false;
            jre8Available = true;
        } else {
            instance = new JreCompat();
            jre9Available = false;
            jre8Available = false;
        }
    }
}

