/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.JNLPMatcherException;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.Parser;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class JNLPMatcher {
    private final Node appTemplateNode;
    private final Node launchJNLPNode;
    private final boolean isTemplate;

    public JNLPMatcher(InputStream appTemplate, InputStream launchJNLP, boolean isTemplate, ParserSettings p) throws JNLPMatcherException {
        if (appTemplate == null && launchJNLP == null) {
            throw new JNLPMatcherException("Template JNLP file and Launching JNLP file are both null.");
        }
        if (appTemplate == null) {
            throw new JNLPMatcherException("Template JNLP file is null.");
        }
        if (launchJNLP == null) {
            throw new JNLPMatcherException("Launching JNLP file is null.");
        }
        try {
            this.appTemplateNode = Parser.getRootNode(appTemplate, p);
            this.launchJNLPNode = Parser.getRootNode(launchJNLP, p);
            this.isTemplate = isTemplate;
        }
        catch (Exception e) {
            throw new JNLPMatcherException("Failed to create an instance of JNLPVerify with specified InputStreamReader", e);
        }
        finally {
            this.closeInputStream(appTemplate);
            this.closeInputStream(launchJNLP);
        }
    }

    public boolean isMatch() {
        return this.matchNodes(this.appTemplateNode, this.launchJNLPNode);
    }

    private boolean matchNodes(Node appTemplate, Node launchJNLP) {
        if (appTemplate != null && launchJNLP != null) {
            Node templateNode = appTemplate;
            Node launchNode = launchJNLP;
            LinkedList<Node> appTemplateChild = new LinkedList<Node>(Arrays.asList(templateNode.getChildNodes()));
            LinkedList<Node> launchJNLPChild = new LinkedList<Node>(Arrays.asList(launchNode.getChildNodes()));
            if (templateNode.getNodeName().equals(launchNode.getNodeName()) && appTemplateChild.size() == launchJNLPChild.size()) {
                int childLength = appTemplateChild.size();
                int i = 0;
                block0: while (i < childLength) {
                    for (int j = 0; j < childLength; ++j) {
                        boolean isSame = this.matchNodes((Node)appTemplateChild.get(i), (Node)launchJNLPChild.get(j));
                        if (!isSame && j == childLength - 1) {
                            return false;
                        }
                        if (!isSame) continue;
                        appTemplateChild.remove(i);
                        launchJNLPChild.remove(j);
                        --childLength;
                        continue block0;
                    }
                }
                if (!templateNode.getNodeValue().equals(launchNode.getNodeValue())) {
                    if (this.isTemplate && !templateNode.getNodeValue().equals("*")) {
                        return false;
                    }
                    if (!this.isTemplate) {
                        return false;
                    }
                }
                return this.matchAttributes(templateNode, launchNode);
            }
        }
        return false;
    }

    private boolean matchAttributes(Node templateNode, Node launchNode) {
        if (templateNode != null && launchNode != null) {
            List<String> appTemplateAttributes = templateNode.getAttributeNames();
            List<String> launchJNLPAttributes = launchNode.getAttributeNames();
            Collections.sort(appTemplateAttributes);
            Collections.sort(launchJNLPAttributes);
            if (appTemplateAttributes.size() == launchJNLPAttributes.size()) {
                int size = appTemplateAttributes.size();
                for (int i = 0; i < size; ++i) {
                    if (launchJNLPAttributes.get(i).equals(appTemplateAttributes.get(i))) {
                        String attribute = launchJNLPAttributes.get(i);
                        boolean isSame = templateNode.getAttribute(attribute).equals(launchNode.getAttribute(attribute));
                        if (!this.isTemplate && !isSame) {
                            return false;
                        }
                        if (!this.isTemplate || isSame || templateNode.getAttribute(attribute).equals("*")) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
    }

    private void closeOutputStream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
    }
}

