/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;

public class ControlCurve {
    protected Polygon pts;
    protected Polygon result;
    protected boolean withPoints = true;
    protected int selection = -1;
    static Font f = new Font("Courier", 0, 12);
    static final int EPSILON = 36;

    public ControlCurve() {
        this.pts = new Polygon();
    }

    public ControlCurve(Polygon p) {
        this.pts = p;
    }

    public Polygon getSourcePolygon() {
        return this.pts;
    }

    public void setSourcePolygon(Polygon pts) {
        this.pts = pts;
    }

    public Polygon calcualteResult() {
        return null;
    }

    public void calcualteAndSaveResult() {
        this.result = this.calcualteResult();
    }

    public void paint(Graphics g) {
        if (this.isWithPoints()) {
            FontMetrics fm = g.getFontMetrics(f);
            g.setFont(f);
            int h = fm.getAscent() / 2;
            for (int i = 0; i < this.pts.npoints; ++i) {
                String s = Integer.toString(i);
                int w = fm.stringWidth(s) / 2;
                g.drawString(Integer.toString(i), this.pts.xpoints[i] - w, this.pts.ypoints[i] + h);
            }
        }
    }

    public int selectPoint(int x, int y) {
        int mind = Integer.MAX_VALUE;
        this.selection = -1;
        for (int i = 0; i < this.pts.npoints; ++i) {
            int d = ControlCurve.sqr(this.pts.xpoints[i] - x) + ControlCurve.sqr(this.pts.ypoints[i] - y);
            if (d >= mind || d >= 36) continue;
            mind = d;
            this.selection = i;
        }
        return this.selection;
    }

    static int sqr(int x) {
        return x * x;
    }

    public Polygon getResult() {
        return this.result;
    }

    public void resetResult() {
        this.result = null;
    }

    public int addPoint(int x, int y) {
        this.pts.addPoint(x, y);
        this.resetResult();
        this.selection = this.pts.npoints - 1;
        return this.selection;
    }

    public void setPoint(int x, int y) {
        this.setPoint(this.selection, x, y);
    }

    public void setPoint(int index, int x, int y) {
        if (index >= 0 && index < this.pts.npoints) {
            this.pts.xpoints[index] = x;
            this.pts.ypoints[index] = y;
            this.resetResult();
        }
    }

    public void removePoint(int index) {
        if (index >= 0 && index < this.pts.npoints) {
            --this.pts.npoints;
            for (int i = index; i < this.pts.npoints; ++i) {
                this.pts.xpoints[i] = this.pts.xpoints[i + 1];
                this.pts.ypoints[i] = this.pts.ypoints[i + 1];
            }
            this.resetResult();
        }
    }

    public void removePoint() {
        this.removePoint(this.selection);
    }

    public boolean isWithPoints() {
        return this.withPoints;
    }

    public void setWithPoints(boolean withPoints) {
        this.withPoints = withPoints;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < this.pts.npoints; ++i) {
            r.append(" ").append(this.pts.xpoints[i]).append(" ").append(this.pts.ypoints[i]);
        }
        return r.toString();
    }

    void setSelection(int selection) {
        this.selection = selection;
    }
}

