/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.dbcp.dbcp2.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.SQLExceptionList;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;

public class PoolablePreparedStatement<K>
extends DelegatingPreparedStatement {
    private final KeyedObjectPool<K, PoolablePreparedStatement<K>> pool;
    private final K key;
    private volatile boolean batchAdded = false;

    public PoolablePreparedStatement(PreparedStatement preparedStatement, K k, KeyedObjectPool<K, PoolablePreparedStatement<K>> keyedObjectPool, DelegatingConnection<?> delegatingConnection) {
        super(delegatingConnection, preparedStatement);
        this.pool = keyedObjectPool;
        this.key = k;
        this.removeThisTrace(this.getConnectionInternal());
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch();
        this.batchAdded = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchAdded = false;
        super.clearBatch();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this.pool.returnObject(this.key, this);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLException("Cannot close preparedstatement (return to pool failed)", exception);
            }
        }
    }

    @Override
    public void activate() throws SQLException {
        this.setClosedInternal(false);
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().addTrace(this);
        }
        super.activate();
    }

    @Override
    public void passivate() throws SQLException {
        if (this.batchAdded) {
            this.clearBatch();
        }
        this.setClosedInternal(true);
        this.removeThisTrace(this.getConnectionInternal());
        List<AbandonedTrace> list = this.getTrace();
        if (list != null) {
            ResultSet[] resultSetArray;
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            for (ResultSet resultSet : resultSetArray = list.toArray(new ResultSet[0])) {
                if (resultSet == null) continue;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    arrayList.add(exception);
                }
            }
            this.clearTrace();
            if (!arrayList.isEmpty()) {
                throw new SQLExceptionList(arrayList);
            }
        }
        super.passivate();
    }
}

