/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tomcat.dbcp.pool2.BaseObjectPool;
import org.apache.tomcat.dbcp.pool2.PoolUtils;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.LinkedBlockingDeque;
import org.apache.tomcat.dbcp.pool2.impl.PooledSoftReference;

public class SoftReferenceObjectPool<T>
extends BaseObjectPool<T> {
    private final PooledObjectFactory<T> factory;
    private final ReferenceQueue<T> refQueue = new ReferenceQueue();
    private int numActive = 0;
    private long destroyCount = 0L;
    private long createCount = 0L;
    private final LinkedBlockingDeque<PooledSoftReference<T>> idleReferences = new LinkedBlockingDeque();
    private final ArrayList<PooledSoftReference<T>> allReferences = new ArrayList();

    public SoftReferenceObjectPool(PooledObjectFactory<T> pooledObjectFactory) {
        this.factory = pooledObjectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T borrowObject() throws Exception {
        this.assertOpen();
        Object var1_1 = null;
        boolean bl = false;
        PooledSoftReference<Object> pooledSoftReference = null;
        while (null == var1_1) {
            if (this.idleReferences.isEmpty()) {
                if (null == this.factory) {
                    throw new NoSuchElementException();
                }
                bl = true;
                var1_1 = this.factory.makeObject().getObject();
                ++this.createCount;
                pooledSoftReference = new PooledSoftReference<Object>(new SoftReference<Object>(var1_1));
                this.allReferences.add(pooledSoftReference);
            } else {
                pooledSoftReference = this.idleReferences.pollFirst();
                var1_1 = pooledSoftReference.getObject();
                pooledSoftReference.getReference().clear();
                pooledSoftReference.setReference(new SoftReference<Object>(var1_1));
            }
            if (null == this.factory || null == var1_1) continue;
            try {
                this.factory.activateObject(pooledSoftReference);
                if (this.factory.validateObject(pooledSoftReference)) continue;
                throw new Exception("ValidateObject failed");
            }
            catch (Throwable throwable) {
                PoolUtils.checkRethrow(throwable);
                try {
                    this.destroy(pooledSoftReference);
                }
                catch (Throwable throwable2) {
                    PoolUtils.checkRethrow(throwable2);
                }
                finally {
                    var1_1 = null;
                }
                if (!bl) continue;
                throw new NoSuchElementException("Could not create a validated object, cause: " + throwable.getMessage());
            }
        }
        ++this.numActive;
        pooledSoftReference.allocate();
        return var1_1;
    }

    @Override
    public synchronized void returnObject(T t) throws Exception {
        boolean bl = !this.isClosed();
        PooledSoftReference<T> pooledSoftReference = this.findReference(t);
        if (pooledSoftReference == null) {
            throw new IllegalStateException("Returned object not currently part of this pool");
        }
        if (this.factory != null) {
            if (!this.factory.validateObject(pooledSoftReference)) {
                bl = false;
            } else {
                try {
                    this.factory.passivateObject(pooledSoftReference);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
        }
        boolean bl2 = !bl;
        --this.numActive;
        if (bl) {
            pooledSoftReference.deallocate();
            this.idleReferences.add(pooledSoftReference);
        }
        this.notifyAll();
        if (bl2 && this.factory != null) {
            try {
                this.destroy(pooledSoftReference);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void invalidateObject(T t) throws Exception {
        PooledSoftReference<T> pooledSoftReference = this.findReference(t);
        if (pooledSoftReference == null) {
            throw new IllegalStateException("Object to invalidate is not currently part of this pool");
        }
        if (this.factory != null) {
            this.destroy(pooledSoftReference);
        }
        --this.numActive;
        this.notifyAll();
    }

    @Override
    public synchronized void addObject() throws Exception {
        boolean bl;
        this.assertOpen();
        if (this.factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        T t = this.factory.makeObject().getObject();
        ++this.createCount;
        PooledSoftReference<T> pooledSoftReference = new PooledSoftReference<T>(new SoftReference<T>(t, this.refQueue));
        this.allReferences.add(pooledSoftReference);
        boolean bl2 = true;
        if (!this.factory.validateObject(pooledSoftReference)) {
            bl2 = false;
        } else {
            this.factory.passivateObject(pooledSoftReference);
        }
        boolean bl3 = bl = !bl2;
        if (bl2) {
            this.idleReferences.add(pooledSoftReference);
            this.notifyAll();
        }
        if (bl) {
            try {
                this.destroy(pooledSoftReference);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized int getNumIdle() {
        this.pruneClearedReferences();
        return this.idleReferences.size();
    }

    @Override
    public synchronized int getNumActive() {
        return this.numActive;
    }

    @Override
    public synchronized void clear() {
        if (null != this.factory) {
            for (PooledSoftReference<T> pooledSoftReference : this.idleReferences) {
                try {
                    PooledSoftReference<T> pooledSoftReference2 = pooledSoftReference;
                    if (null == pooledSoftReference2.getObject()) continue;
                    this.factory.destroyObject(pooledSoftReference2);
                }
                catch (Exception exception) {}
            }
        }
        this.idleReferences.clear();
        this.pruneClearedReferences();
    }

    @Override
    public void close() {
        super.close();
        this.clear();
    }

    public synchronized PooledObjectFactory<T> getFactory() {
        return this.factory;
    }

    private void pruneClearedReferences() {
        this.removeClearedReferences(this.idleReferences.iterator());
        this.removeClearedReferences(this.allReferences.iterator());
        while (this.refQueue.poll() != null) {
        }
    }

    private PooledSoftReference<T> findReference(T t) {
        for (PooledSoftReference<T> pooledSoftReference : this.allReferences) {
            if (pooledSoftReference.getObject() == null || !pooledSoftReference.getObject().equals(t)) continue;
            return pooledSoftReference;
        }
        return null;
    }

    private void destroy(PooledSoftReference<T> pooledSoftReference) throws Exception {
        pooledSoftReference.invalidate();
        this.idleReferences.remove(pooledSoftReference);
        this.allReferences.remove(pooledSoftReference);
        try {
            this.factory.destroyObject(pooledSoftReference);
        }
        finally {
            ++this.destroyCount;
            pooledSoftReference.getReference().clear();
        }
    }

    private void removeClearedReferences(Iterator<PooledSoftReference<T>> iterator) {
        while (iterator.hasNext()) {
            PooledSoftReference<T> pooledSoftReference = iterator.next();
            if (pooledSoftReference.getReference() != null && !pooledSoftReference.getReference().isEnqueued()) continue;
            iterator.remove();
        }
    }

    @Override
    protected void toStringAppendFields(StringBuilder stringBuilder) {
        super.toStringAppendFields(stringBuilder);
        stringBuilder.append(", factory=");
        stringBuilder.append(this.factory);
        stringBuilder.append(", refQueue=");
        stringBuilder.append(this.refQueue);
        stringBuilder.append(", numActive=");
        stringBuilder.append(this.numActive);
        stringBuilder.append(", destroyCount=");
        stringBuilder.append(this.destroyCount);
        stringBuilder.append(", createCount=");
        stringBuilder.append(this.createCount);
        stringBuilder.append(", idleReferences=");
        stringBuilder.append(this.idleReferences);
        stringBuilder.append(", allReferences=");
        stringBuilder.append(this.allReferences);
    }
}

