/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import org.apache.tomcat.util.buf.AbstractChunk;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.StringCache;

public final class CharChunk
extends AbstractChunk
implements CharSequence {
    private static final long serialVersionUID = 1L;
    private char[] buff;
    private transient CharInputChannel in = null;
    private transient CharOutputChannel out = null;

    public CharChunk() {
    }

    public CharChunk(int n) {
        this.allocate(n, -1);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void allocate(int n, int n2) {
        if (this.buff == null || this.buff.length < n) {
            this.buff = new char[n];
        }
        this.setLimit(n2);
        this.start = 0;
        this.end = 0;
        this.isSet = true;
        this.hasHashCode = false;
    }

    public void setChars(char[] cArray, int n, int n2) {
        this.buff = cArray;
        this.start = n;
        this.end = this.start + n2;
        this.isSet = true;
        this.hasHashCode = false;
    }

    public char[] getChars() {
        return this.getBuffer();
    }

    public char[] getBuffer() {
        return this.buff;
    }

    public void setCharInputChannel(CharInputChannel charInputChannel) {
        this.in = charInputChannel;
    }

    public void setCharOutputChannel(CharOutputChannel charOutputChannel) {
        this.out = charOutputChannel;
    }

    public void append(char c) throws IOException {
        this.makeSpace(1);
        int n = this.getLimitInternal();
        if (this.end >= n) {
            this.flushBuffer();
        }
        this.buff[this.end++] = c;
    }

    public void append(CharChunk charChunk) throws IOException {
        this.append(charChunk.getBuffer(), charChunk.getOffset(), charChunk.getLength());
    }

    public void append(char[] cArray, int n, int n2) throws IOException {
        this.makeSpace(n2);
        int n3 = this.getLimitInternal();
        if (n2 == n3 && this.end == this.start && this.out != null) {
            this.out.realWriteChars(cArray, n, n2);
            return;
        }
        if (n2 <= n3 - this.end) {
            System.arraycopy(cArray, n, this.buff, this.end, n2);
            this.end += n2;
            return;
        }
        if (n2 + this.end < 2 * n3) {
            int n4 = n3 - this.end;
            System.arraycopy(cArray, n, this.buff, this.end, n4);
            this.end += n4;
            this.flushBuffer();
            System.arraycopy(cArray, n + n4, this.buff, this.end, n2 - n4);
            this.end += n2 - n4;
        } else {
            this.flushBuffer();
            this.out.realWriteChars(cArray, n, n2);
        }
    }

    public void append(String string) throws IOException {
        this.append(string, 0, string.length());
    }

    public void append(String string, int n, int n2) throws IOException {
        if (string == null) {
            return;
        }
        this.makeSpace(n2);
        int n3 = this.getLimitInternal();
        int n4 = n;
        int n5 = n + n2;
        while (n4 < n5) {
            int n6 = this.min(n3 - this.end, n5 - n4);
            string.getChars(n4, n4 + n6, this.buff, this.end);
            n4 += n6;
            this.end += n6;
            if (this.end < n3) continue;
            this.flushBuffer();
        }
    }

    public int substract() throws IOException {
        if (this.checkEof()) {
            return -1;
        }
        return this.buff[this.start++];
    }

    public int substract(char[] cArray, int n, int n2) throws IOException {
        if (this.checkEof()) {
            return -1;
        }
        int n3 = n2;
        if (n2 > this.getLength()) {
            n3 = this.getLength();
        }
        System.arraycopy(this.buff, this.start, cArray, n, n3);
        this.start += n3;
        return n3;
    }

    private boolean checkEof() throws IOException {
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return true;
            }
            int n = this.in.realReadChars();
            if (n < 0) {
                return true;
            }
        }
        return false;
    }

    public void flushBuffer() throws IOException {
        if (this.out == null) {
            throw new IOException("Buffer overflow, no sink " + this.getLimit() + " " + this.buff.length);
        }
        this.out.realWriteChars(this.buff, this.start, this.end - this.start);
        this.end = this.start;
    }

    public void makeSpace(int n) {
        char[] cArray = null;
        long l = this.end + n;
        int n2 = this.getLimitInternal();
        if (l > (long)n2) {
            l = n2;
        }
        if (this.buff == null) {
            if (l < 256L) {
                l = 256L;
            }
            this.buff = new char[(int)l];
        }
        if (l <= (long)this.buff.length) {
            return;
        }
        long l2 = l < 2L * (long)this.buff.length ? (long)this.buff.length * 2L : (long)this.buff.length * 2L + (long)n;
        if (l2 > (long)n2) {
            l2 = n2;
        }
        cArray = new char[(int)l2];
        System.arraycopy(this.buff, 0, cArray, 0, this.end);
        this.buff = cArray;
        cArray = null;
    }

    @Override
    public String toString() {
        if (null == this.buff) {
            return null;
        }
        if (this.end - this.start == 0) {
            return "";
        }
        return StringCache.toString(this);
    }

    public String toStringInternal() {
        return new String(this.buff, this.start, this.end - this.start);
    }

    public boolean equals(Object object) {
        if (object instanceof CharChunk) {
            return this.equals((CharChunk)object);
        }
        return false;
    }

    public boolean equals(String string) {
        char[] cArray = this.buff;
        int n = this.end - this.start;
        if (cArray == null || n != string.length()) {
            return false;
        }
        int n2 = this.start;
        for (int i = 0; i < n; ++i) {
            if (cArray[n2++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        char[] cArray = this.buff;
        int n = this.end - this.start;
        if (cArray == null || n != string.length()) {
            return false;
        }
        int n2 = this.start;
        for (int i = 0; i < n; ++i) {
            if (Ascii.toLower(cArray[n2++]) == Ascii.toLower(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharChunk charChunk) {
        return this.equals(charChunk.getChars(), charChunk.getOffset(), charChunk.getLength());
    }

    public boolean equals(char[] cArray, int n, int n2) {
        char[] cArray2 = this.buff;
        if (cArray2 == null && cArray == null) {
            return true;
        }
        int n3 = this.end - this.start;
        if (n3 != n2 || cArray2 == null || cArray == null) {
            return false;
        }
        int n4 = this.start;
        while (n3-- > 0) {
            if (cArray2[n4++] == cArray[n++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string) {
        char[] cArray = this.buff;
        int n = string.length();
        if (cArray == null || n > this.end - this.start) {
            return false;
        }
        int n2 = this.start;
        for (int i = 0; i < n; ++i) {
            if (cArray[n2++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String string, int n) {
        char[] cArray = this.buff;
        int n2 = string.length();
        if (cArray == null || n2 + n > this.end - this.start) {
            return false;
        }
        int n3 = this.start + n;
        for (int i = 0; i < n2; ++i) {
            if (Ascii.toLower(cArray[n3++]) == Ascii.toLower(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String string) {
        char[] cArray = this.buff;
        int n = string.length();
        if (cArray == null || n > this.end - this.start) {
            return false;
        }
        int n2 = this.end - n;
        for (int i = 0; i < n; ++i) {
            if (cArray[n2++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getBufferElement(int n) {
        return this.buff[n];
    }

    public int indexOf(char c) {
        return this.indexOf(c, this.start);
    }

    public int indexOf(char c, int n) {
        int n2 = CharChunk.indexOf(this.buff, this.start + n, this.end, c);
        return n2 >= this.start ? n2 - this.start : -1;
    }

    public static int indexOf(char[] cArray, int n, int n2, char c) {
        for (int i = n; i < n2; ++i) {
            char c2 = cArray[i];
            if (c2 != c) continue;
            return i;
        }
        return -1;
    }

    private int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    @Override
    public char charAt(int n) {
        return this.buff[n + this.start];
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        try {
            CharChunk charChunk = (CharChunk)this.clone();
            charChunk.setOffset(this.start + n);
            charChunk.setEnd(this.start + n2);
            return charChunk;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Deprecated
    public void setOptimizedWrite(boolean bl) {
    }

    public static interface CharOutputChannel {
        public void realWriteChars(char[] var1, int var2, int var3) throws IOException;
    }

    public static interface CharInputChannel {
        public int realReadChars() throws IOException;
    }
}

